/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.mqtt;

import io.gatling.core.protocol.Protocol;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.mqtt.LastWillBuilder;
import io.gatling.javaapi.mqtt.internal.MessageCorrelators;
import java.time.Duration;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import org.jspecify.annotations.NonNull;

public abstract class MqttProtocolBuilderBase<T extends MqttProtocolBuilderBase<T, W>, W extends io.gatling.mqtt.protocol.MqttProtocolBuilderBase<W>>
implements ProtocolBuilder {
    protected W wrapped;

    MqttProtocolBuilderBase(W w) {
        this.wrapped = w;
    }

    protected abstract T make(Function<W, W> var1);

    public @NonNull T mqttVersion_3_1() {
        return this.make(io.gatling.mqtt.protocol.MqttProtocolBuilderBase::mqttVersion_3_1);
    }

    public @NonNull T mqttVersion_3_1_1() {
        return this.make(io.gatling.mqtt.protocol.MqttProtocolBuilderBase::mqttVersion_3_1_1);
    }

    public @NonNull T mqttVersion_5() {
        return this.make(io.gatling.mqtt.protocol.MqttProtocolBuilderBase::mqttVersion_5);
    }

    public @NonNull T broker(@NonNull String string, int n) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.broker(string, n));
    }

    public @NonNull T useTls(boolean bl) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.useTls(bl));
    }

    public @NonNull T perUserKeyManagerFactory(@NonNull Function<Long, KeyManagerFactory> function) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.perUserKeyManagerFactory(object -> (KeyManagerFactory)function.apply((Long)object)));
    }

    public @NonNull T clientId(@NonNull String string) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.clientId(Expressions.toStringExpression((String)string)));
    }

    public @NonNull T clientId(@NonNull Function<Session, String> function) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.clientId(Expressions.javaFunctionToExpression((Function)function)));
    }

    public @NonNull T cleanSession(boolean bl) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.cleanSession(bl));
    }

    public @NonNull T connectTimeout(long l) {
        return this.connectTimeout(Duration.ofSeconds(l));
    }

    public @NonNull T connectTimeout(@NonNull Duration duration) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.connectTimeout(Converters.toScalaDuration((Duration)duration)));
    }

    public @NonNull T keepAlive(long l) {
        return this.keepAlive(Duration.ofSeconds(l));
    }

    public @NonNull T keepAlive(@NonNull Duration duration) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.keepAlive(Converters.toScalaDuration((Duration)duration)));
    }

    public @NonNull T qosAtMostOnce() {
        return this.make(io.gatling.mqtt.protocol.MqttProtocolBuilderBase::qosAtMostOnce);
    }

    public @NonNull T qosAtLeastOnce() {
        return this.make(io.gatling.mqtt.protocol.MqttProtocolBuilderBase::qosAtLeastOnce);
    }

    public @NonNull T qosExactlyOnce() {
        return this.make(io.gatling.mqtt.protocol.MqttProtocolBuilderBase::qosExactlyOnce);
    }

    public @NonNull T retain(boolean bl) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.retain(bl));
    }

    public @NonNull T credentials(@NonNull String string, @NonNull String string2) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.credentials(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2)));
    }

    public @NonNull T credentials(@NonNull Function<Session, String> function, @NonNull String string) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.credentials(Expressions.javaFunctionToExpression((Function)function), Expressions.toStringExpression((String)string)));
    }

    public @NonNull T credentials(@NonNull String string, @NonNull Function<Session, String> function) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.credentials(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression((Function)function)));
    }

    public @NonNull T credentials(@NonNull Function<Session, String> function, @NonNull Function<Session, String> function2) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.credentials(Expressions.javaFunctionToExpression((Function)function), Expressions.javaFunctionToExpression((Function)function2)));
    }

    public @NonNull T lastWill(@NonNull LastWillBuilder lastWillBuilder) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.lastWill(lastWillBuilder.asScala()));
    }

    public @NonNull T reconnectAttemptsMax(int n) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.reconnectAttemptsMax(n));
    }

    public @NonNull T reconnectDelay(long l) {
        return this.reconnectDelay(Duration.ofSeconds(l));
    }

    public @NonNull T reconnectDelay(@NonNull Duration duration) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.reconnectDelay(Converters.toScalaDuration((Duration)duration)));
    }

    public @NonNull T reconnectBackoffMultiplier(float f) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.reconnectBackoffMultiplier(f));
    }

    public @NonNull T resendDelay(long l) {
        return this.resendDelay(Duration.ofSeconds(l));
    }

    public @NonNull T resendDelay(@NonNull Duration duration) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.resendDelay(Converters.toScalaDuration((Duration)duration)));
    }

    public @NonNull T resendBackoffMultiplier(float f) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.resendBackoffMultiplier(f));
    }

    public @NonNull T correlateBy(@NonNull CheckBuilder checkBuilder) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.correlateBy(MessageCorrelators.toScalaCorrelator(checkBuilder)));
    }

    public @NonNull T timeoutCheckInterval(long l) {
        return this.timeoutCheckInterval(Duration.ofSeconds(l));
    }

    public @NonNull T unmatchedInboundMessageBufferSize(int n) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.unmatchedInboundMessageBufferSize(n));
    }

    public @NonNull T timeoutCheckInterval(@NonNull Duration duration) {
        return this.make(mqttProtocolBuilderBase -> mqttProtocolBuilderBase.timeoutCheckInterval(Converters.toScalaDuration((Duration)duration)));
    }

    public Protocol protocol() {
        return this.wrapped.build();
    }
}

