/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.jms;

import io.gatling.core.protocol.Protocol;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.jms.JmsJndiConnectionFactoryBuilder;
import io.gatling.javaapi.jms.JmsMessageMatcher;
import io.gatling.javaapi.jms.internal.JmsMessageMatchers;
import io.gatling.jms.protocol.JmsProtocolBuilderBase;
import jakarta.jms.ConnectionFactory;
import java.time.Duration;
import org.jspecify.annotations.NonNull;

public final class JmsProtocolBuilder
implements ProtocolBuilder {
    private final io.gatling.jms.protocol.JmsProtocolBuilder wrapped;

    public JmsProtocolBuilder(io.gatling.jms.protocol.JmsProtocolBuilder jmsProtocolBuilder) {
        this.wrapped = jmsProtocolBuilder;
    }

    public Protocol protocol() {
        return this.wrapped.build();
    }

    public @NonNull JmsProtocolBuilder credentials(@NonNull String string, @NonNull String string2) {
        return new JmsProtocolBuilder(this.wrapped.credentials(string, string2));
    }

    public @NonNull JmsProtocolBuilder usePersistentDeliveryMode() {
        return new JmsProtocolBuilder(this.wrapped.usePersistentDeliveryMode());
    }

    public @NonNull JmsProtocolBuilder useNonPersistentDeliveryMode() {
        return new JmsProtocolBuilder(this.wrapped.useNonPersistentDeliveryMode());
    }

    public @NonNull JmsProtocolBuilder matchByMessageId() {
        return new JmsProtocolBuilder(this.wrapped.matchByMessageId());
    }

    public @NonNull JmsProtocolBuilder matchByCorrelationId() {
        return new JmsProtocolBuilder(this.wrapped.matchByCorrelationId());
    }

    public @NonNull JmsProtocolBuilder messageMatcher(@NonNull JmsMessageMatcher jmsMessageMatcher) {
        return new JmsProtocolBuilder(this.wrapped.messageMatcher(JmsMessageMatchers.toScala(jmsMessageMatcher)));
    }

    public @NonNull JmsProtocolBuilder replyTimeout(long l) {
        return this.replyTimeout(Duration.ofSeconds(l));
    }

    public @NonNull JmsProtocolBuilder replyTimeout(Duration duration) {
        return new JmsProtocolBuilder(this.wrapped.replyTimeout(Converters.toScalaDuration((Duration)duration)));
    }

    public @NonNull JmsProtocolBuilder listenerThreadCount(int n) {
        return new JmsProtocolBuilder(this.wrapped.listenerThreadCount(n));
    }

    public static final class Base {
        public static final Base INSTANCE = new Base();

        private Base() {
        }

        public @NonNull JmsProtocolBuilder connectionFactory(@NonNull ConnectionFactory connectionFactory) {
            return new JmsProtocolBuilder(JmsProtocolBuilderBase.connectionFactory((ConnectionFactory)connectionFactory));
        }

        public @NonNull JmsProtocolBuilder connectionFactory(@NonNull JmsJndiConnectionFactoryBuilder jmsJndiConnectionFactoryBuilder) {
            return new JmsProtocolBuilder(JmsProtocolBuilderBase.connectionFactory((ConnectionFactory)jmsJndiConnectionFactoryBuilder.build()));
        }
    }
}

