/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.cookie;

import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.session.Session;
import io.gatling.core.session.SessionPrivateAttributes$;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.cookie.CookieJar;
import io.gatling.http.cookie.CookieJar$;
import io.gatling.http.cookie.CookieKey;
import io.gatling.http.cookie.StoredCookie;
import io.netty.handler.codec.http.cookie.Cookie;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class CookieSupport$ {
    public static final CookieSupport$ MODULE$ = new CookieSupport$();
    private static final String CookieJarAttributeName = SessionPrivateAttributes$.MODULE$.generatePrivateAttribute("http.cookies");
    private static final Failure NoCookieJarFailure = package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("No CookieJar in session"));
    private static final Function1<Session, Validation<Session>> io$gatling$http$cookie$CookieSupport$$FlushSessionCookies = (Function1 & Serializable)session -> {
        Option<CookieJar> option = MODULE$.cookieJar((Session)session);
        if (option instanceof Some) {
            Some some = (Some)option;
            CookieJar cookieJar = (CookieJar)some.value();
            Map storeWithOnlyPersistentCookies = (Map)cookieJar.store().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CookieSupport$.$anonfun$FlushSessionCookies$2(x0$1)));
            return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)session.set(MODULE$.CookieJarAttributeName(), (Object)new CookieJar((Map<CookieKey, StoredCookie>)storeWithOnlyPersistentCookies))));
        }
        return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper(session));
    };
    private static final Function1<Session, Validation<Session>> io$gatling$http$cookie$CookieSupport$$FlushCookieJar = (Function1 & Serializable)x$2 -> package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)x$2.remove(MODULE$.CookieJarAttributeName())));

    public String CookieJarAttributeName() {
        return CookieJarAttributeName;
    }

    private Failure NoCookieJarFailure() {
        return NoCookieJarFailure;
    }

    private Option<CookieJar> cookieJar(Session session) {
        return session.attributes().get((Object)this.CookieJarAttributeName()).map((Function1 & Serializable)x$1 -> (CookieJar)x$1);
    }

    public List<Cookie> getStoredCookies(Session session, Uri uri) {
        Option<CookieJar> option = this.cookieJar(session);
        if (option instanceof Some) {
            Some some = (Some)option;
            CookieJar cookieJar = (CookieJar)some.value();
            return cookieJar.get(uri);
        }
        return Nil$.MODULE$;
    }

    private CookieJar getOrCreateCookieJar(Session session) {
        Option<CookieJar> option = this.cookieJar(session);
        if (option instanceof Some) {
            Some some = (Some)option;
            CookieJar cookieJar = (CookieJar)some.value();
            return cookieJar;
        }
        return CookieJar$.MODULE$.Empty();
    }

    public Session storeCookies(Session session, Uri uri, List<Cookie> cookies, long nowMillis) {
        if (cookies.isEmpty()) {
            return session;
        }
        CookieJar cookieJar = this.getOrCreateCookieJar(session);
        return session.set(this.CookieJarAttributeName(), (Object)cookieJar.add(uri, cookies, nowMillis));
    }

    public Session storeCookie(Session session, String domain, String path, Cookie cookie, long nowMillis) {
        CookieJar cookieJar = this.getOrCreateCookieJar(session);
        Cookie cookie2 = cookie;
        return session.set(this.CookieJarAttributeName(), (Object)cookieJar.add(domain, path, (List<Cookie>)Nil$.MODULE$.$colon$colon((Object)cookie2), nowMillis));
    }

    public Validation<String> getCookieValue(Session session, String name, String domain, Option<String> path, Option<Object> secure) {
        Option<CookieJar> option = this.cookieJar(session);
        if (option instanceof Some) {
            Some some = (Some)option;
            CookieJar cookieJar = (CookieJar)some.value();
            List<Cookie> list = cookieJar.find(name, domain, path, secure);
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                Cookie cookie = (Cookie)colon2.head();
                List list2 = colon2.next$access$1();
                if (Nil$.MODULE$.equals(list2)) {
                    return package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)cookie.value()));
                }
            }
            if (Nil$.MODULE$.equals(list)) {
                return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("No cookie matching (name=" + name + ", domain=" + domain + ", path=" + path + ", secure=" + secure + ")"));
            }
            return package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("Found more than one cookie matching (name=" + name + ", domain=" + domain + ", path=" + path + ", secure=" + secure + ")"));
        }
        return this.NoCookieJarFailure();
    }

    public Function1<Session, Validation<Session>> io$gatling$http$cookie$CookieSupport$$FlushSessionCookies() {
        return io$gatling$http$cookie$CookieSupport$$FlushSessionCookies;
    }

    public Function1<Session, Validation<Session>> io$gatling$http$cookie$CookieSupport$$FlushCookieJar() {
        return io$gatling$http$cookie$CookieSupport$$FlushCookieJar;
    }

    public static final /* synthetic */ boolean $anonfun$FlushSessionCookies$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StoredCookie storeCookie = (StoredCookie)tuple2._2();
            return storeCookie.persistent();
        }
        throw new MatchError((Object)tuple2);
    }

    private CookieSupport$() {
    }
}

