/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.http;

import io.gatling.core.Predef;
import io.gatling.core.body.Body;
import io.gatling.http.request.builder.RequestWithBodyBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Bodies;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.http.BodyPart;
import io.gatling.javaapi.http.RequestActionBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public abstract class RequestWithBodyActionBuilder<T extends RequestWithBodyActionBuilder<T, W>, W extends RequestWithBodyBuilder<W>>
extends RequestActionBuilder<T, W> {
    RequestWithBodyActionBuilder(W w) {
        super(w);
    }

    public @NonNull T body(io.gatling.javaapi.core.Body body) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.body(body.asScala())));
    }

    public @NonNull T processRequestBody(@NonNull Function<io.gatling.javaapi.core.Body, ? extends io.gatling.javaapi.core.Body> function) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.processRequestBody(body -> ((io.gatling.javaapi.core.Body)function.apply(Bodies.toJavaBody((Body)body))).asScala())));
    }

    public @NonNull T bodyPart(@NonNull BodyPart bodyPart) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.bodyPart(bodyPart.asScala())));
    }

    public @NonNull T bodyParts(BodyPart ... bodyPartArray) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.bodyParts(Converters.toScalaSeq(Arrays.stream(bodyPartArray).map(BodyPart::asScala).collect(Collectors.toList())))));
    }

    public @NonNull T bodyParts(@NonNull List<BodyPart> list) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.bodyParts(Converters.toScalaSeq(list.stream().map(BodyPart::asScala).collect(Collectors.toList())))));
    }

    public @NonNull T asMultipartForm() {
        return (T)((RequestWithBodyActionBuilder)this.make(RequestWithBodyBuilder::asMultipartForm));
    }

    public @NonNull T asFormUrlEncoded() {
        return (T)((RequestWithBodyActionBuilder)this.make(RequestWithBodyBuilder::asFormUrlEncoded));
    }

    public @NonNull T formParam(@NonNull String string, @NonNull String string2) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formParam(Expressions.toStringExpression((String)string), Expressions.toAnyExpression((String)string2))));
    }

    public @NonNull T formParam(@NonNull Function<Session, String> function, @NonNull String string) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formParam(Expressions.javaFunctionToExpression((Function)function), Expressions.toAnyExpression((String)string))));
    }

    public @NonNull T formParam(@NonNull String string, @NonNull Object object) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formParam(Expressions.toStringExpression((String)string), Expressions.toStaticValueExpression((Object)object))));
    }

    public @NonNull T formParam(@NonNull Function<Session, String> function, @NonNull Object object) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formParam(Expressions.javaFunctionToExpression((Function)function), Expressions.toStaticValueExpression((Object)object))));
    }

    public @NonNull T formParam(@NonNull String string, @NonNull Function<Session, Object> function) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formParam(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression((Function)function))));
    }

    public @NonNull T formParam(@NonNull Function<Session, String> function, @NonNull Function<Session, Object> function2) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formParam(Expressions.javaFunctionToExpression((Function)function), Expressions.javaFunctionToExpression((Function)function2))));
    }

    public @NonNull T multivaluedFormParam(@NonNull String string, @NonNull List<Object> list) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.multivaluedFormParam(Expressions.toStringExpression((String)string), Expressions.toStaticValueExpression((Object)Converters.toScalaSeq((List)list)))));
    }

    public @NonNull T multivaluedFormParam(@NonNull String string, @NonNull String string2) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.multivaluedFormParam(Expressions.toStringExpression((String)string), Expressions.toSeqExpression((String)string2))));
    }

    public @NonNull T multivaluedFormParam(@NonNull Function<Session, String> function, @NonNull List<Object> list) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.multivaluedFormParam(Expressions.javaFunctionToExpression((Function)function), Expressions.toStaticValueExpression((Object)Converters.toScalaSeq((List)list)))));
    }

    public @NonNull T multivaluedFormParam(@NonNull String string, @NonNull Function<Session, List<Object>> function) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.multivaluedFormParam(Expressions.toStringExpression((String)string), Expressions.javaListFunctionToExpression((Function)function))));
    }

    public @NonNull T multivaluedFormParam(@NonNull Function<Session, String> function, @NonNull Function<Session, List<Object>> function2) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.multivaluedFormParam(Expressions.javaFunctionToExpression((Function)function), Expressions.javaListFunctionToExpression((Function)function2))));
    }

    public @NonNull T formParamSeq(@NonNull List<Map.Entry<String, Object>> list) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formParamSeq(Converters.toScalaTuple2Seq((List)list))));
    }

    public @NonNull T formParamSeq(@NonNull Function<Session, List<Map.Entry<String, Object>>> function) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formParamSeq(Expressions.javaPairListFunctionToTuple2SeqExpression((Function)function))));
    }

    public @NonNull T formParamMap(@NonNull Map<String, Object> map) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formParamMap(Converters.toScalaMap((Map)map))));
    }

    public @NonNull T formParamMap(@NonNull Function<Session, Map<String, Object>> function) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formParamMap(Expressions.javaMapFunctionToExpression((Function)function))));
    }

    public @NonNull T form(@NonNull String string) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formParamMap(Expressions.toMapExpression((String)string))));
    }

    public @NonNull T form(@NonNull Function<Session, Map<String, Object>> function) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.form(Expressions.javaMapFunctionToExpression((Function)function))));
    }

    public @NonNull T formUpload(@NonNull String string, @NonNull String string2) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formUpload(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2), Predef.rawFileBodies())));
    }

    public @NonNull T formUpload(@NonNull Function<Session, String> function, @NonNull String string) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formUpload(Expressions.javaFunctionToExpression((Function)function), Expressions.toStringExpression((String)string), Predef.rawFileBodies())));
    }

    public @NonNull T formUpload(@NonNull String string, Function<Session, String> function) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formUpload(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression((Function)function), Predef.rawFileBodies())));
    }

    public @NonNull T formUpload(@NonNull Function<Session, String> function, @NonNull Function<Session, String> function2) {
        return (T)((RequestWithBodyActionBuilder)this.make(requestWithBodyBuilder -> requestWithBodyBuilder.formUpload(Expressions.javaFunctionToExpression((Function)function), Expressions.javaFunctionToExpression((Function)function2), Predef.rawFileBodies())));
    }

    public @NonNull T asJson() {
        return (T)((RequestWithBodyActionBuilder)this.make(RequestWithBodyBuilder::asJson));
    }

    public @NonNull T asXml() {
        return (T)((RequestWithBodyActionBuilder)this.make(RequestWithBodyBuilder::asXml));
    }
}

