/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.realm;

import io.gatling.http.client.realm.Realm;
import io.gatling.http.client.uri.Uri;
import io.netty.handler.codec.http.HttpMethod;

public final class DigestRealm
implements Realm {
    public final String username;
    public final String password;
    private final AuthorizationGen authorizationHeaderF;

    public DigestRealm(String string, String string2) {
        this(string, string2, null);
    }

    private DigestRealm(String string, String string2, AuthorizationGen authorizationGen) {
        this.username = string;
        this.password = string2;
        this.authorizationHeaderF = authorizationGen;
    }

    public DigestRealm withAuthorizationGen(AuthorizationGen authorizationGen) {
        return new DigestRealm(this.username, this.password, authorizationGen);
    }

    public String getAuthorizationHeader(HttpMethod httpMethod, Uri uri) {
        if (this.authorizationHeaderF == null) {
            throw new UnsupportedOperationException("authorizationHeaderF is not configured");
        }
        return this.authorizationHeaderF.apply(httpMethod, uri, this.username, this.password);
    }

    public String toString() {
        return "DigestRealm{username='" + this.username + "', password='*******'}";
    }

    @FunctionalInterface
    public static interface AuthorizationGen {
        public String apply(HttpMethod var1, Uri var2, String var3, String var4);
    }
}

