/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.proxy;

import io.gatling.http.client.realm.BasicRealm;
import io.netty.handler.proxy.ProxyHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public abstract class ProxyServer {
    protected final String host;
    protected final int port;
    protected final BasicRealm realm;
    protected final InetSocketAddress address;

    ProxyServer(String string, int n, BasicRealm basicRealm) throws UnknownHostException {
        this.host = string;
        this.port = n;
        this.realm = basicRealm;
        this.address = new InetSocketAddress(InetAddress.getByName(string), n);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public abstract ProxyHandler newProxyHandler();
}

