/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl.request;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;

public final class WritableRequest {
    private final HttpRequest request;
    private final Object content;

    WritableRequest(HttpRequest httpRequest, Object object) {
        this.request = httpRequest;
        this.content = object;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public Object getContent() {
        return this.content;
    }

    public ChannelFuture write(ChannelHandlerContext channelHandlerContext) {
        if (this.content == null) {
            return channelHandlerContext.writeAndFlush((Object)this.request);
        }
        channelHandlerContext.write((Object)this.request);
        channelHandlerContext.write(this.content);
        return channelHandlerContext.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
    }

    public ChannelFuture writeWithoutContent(ChannelHandlerContext channelHandlerContext) {
        return channelHandlerContext.writeAndFlush((Object)this.request);
    }

    public ChannelFuture writeContent(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.write(this.content);
        return channelHandlerContext.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
    }

    public String toString() {
        return "WritableRequest{request=" + String.valueOf(this.request) + ", content=" + String.valueOf(this.content) + "}";
    }
}

