/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.io.input;

import io.gatling.plugin.exceptions.UserQuitException;
import io.gatling.plugin.io.PluginIO;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.io.PluginScanner;
import io.gatling.plugin.util.LambdaExceptionUtil;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class InputChoice {
    private final PluginLogger logger;
    private final PluginScanner scanner;
    private static final int NOT_READ = -1;

    public InputChoice(PluginIO pluginIO) {
        this.scanner = pluginIO.getScanner();
        this.logger = pluginIO.getLogger();
    }

    public int inputInt(int n) {
        return this.inputInt(n, Integer.MAX_VALUE);
    }

    public int inputInt(int n, int n2) {
        int n3 = -1;
        do {
            try {
                int n4 = this.scanner.readInt();
                if (n4 < n || n4 >= n2) {
                    this.logger.error(String.format("%d is not between %d and %d", n4, n, n2 - 1));
                    continue;
                }
                n3 = n4;
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.error("Enter a valid number");
            }
        } while (n3 <= -1);
        return n3;
    }

    public String inputString(LambdaExceptionUtil.ConsumerWithExceptions<String, IllegalArgumentException> consumerWithExceptions) {
        return this.inputStringWithDefault(null, consumerWithExceptions);
    }

    public String inputStringWithDefault(String string, LambdaExceptionUtil.ConsumerWithExceptions<String, IllegalArgumentException> consumerWithExceptions) {
        while (true) {
            this.logger.info("Waiting for user input...");
            String string2 = this.scanner.readString();
            if (string2.isEmpty() && string != null) {
                return string;
            }
            try {
                consumerWithExceptions.accept(string2);
                return string2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.error(illegalArgumentException.getMessage());
                continue;
            }
            break;
        }
    }

    public <T> T inputFromList(List<T> list, Function<T, String> function) throws UserQuitException {
        int n;
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Choices list is empty");
        }
        int n2 = list.size();
        this.logger.info("Type the number corresponding to your choice and press enter");
        this.logger.info("[0] <Quit>");
        for (n = 1; n <= n2; ++n) {
            this.logger.info(String.format("[%d] %s", n, function.apply(list.get(n - 1))));
        }
        n = this.inputInt(0, n2 + 1);
        if (n == 0) {
            throw new UserQuitException();
        }
        return list.get(n - 1);
    }

    public <T> T inputFromList(List<T> list, Function<T, String> function, Comparator<T> comparator) throws UserQuitException {
        List list2 = list.stream().sorted(comparator).collect(Collectors.toList());
        return this.inputFromList(list2, function);
    }

    public String inputFromStringList(List<String> list, boolean bl) throws UserQuitException {
        List<String> list2 = bl ? list.stream().sorted().collect(Collectors.toList()) : list;
        return this.inputFromList(list2, Function.identity());
    }
}

