/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http.api;

import io.gatling.plugin.client.http.api.AbstractApi;
import io.gatling.plugin.client.http.api.ApiPath;
import io.gatling.plugin.client.http.api.HttpResponse;
import io.gatling.plugin.client.http.requests.StartOptionsRequest;
import io.gatling.plugin.client.http.responses.RunSummaryResponse;
import io.gatling.plugin.client.http.responses.SimulationResponse;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.RunNotFoundException;
import io.gatling.plugin.exceptions.SimulationNotFoundException;
import java.net.URL;

public class SimulationsApi
extends AbstractApi {
    private static final ApiPath SIM_PATH = ApiPath.of("simulations");

    public SimulationsApi(URL uRL, String string) {
        super(uRL, string);
    }

    public SimulationResponse getSimulation(String string) throws EnterprisePluginException {
        return this.getJson(SIM_PATH.append(string), SimulationResponse.class, (HttpResponse httpResponse) -> {
            if (httpResponse.code == 404) {
                throw new SimulationNotFoundException(string);
            }
        });
    }

    public RunSummaryResponse startSimulation(String string, StartOptionsRequest startOptionsRequest) throws EnterprisePluginException {
        ApiPath apiPath = SIM_PATH.append("start").addQueryParam("simulation", string);
        return this.postJson(apiPath, (Object)startOptionsRequest, RunSummaryResponse.class);
    }

    public boolean abortRun(String string) throws EnterprisePluginException {
        try {
            this.postJson(SIM_PATH.append("abort"), (Object)new AbortRequest(string), (HttpResponse httpResponse) -> {
                if (httpResponse.code == 404 || httpResponse.code == 400) {
                    throw new RunNotFoundException(string);
                }
            });
            return true;
        }
        catch (RunNotFoundException runNotFoundException) {
            return false;
        }
    }

    static final class AbortRequest {
        public final String run;

        AbortRequest(String string) {
            this.run = string;
        }
    }
}

