/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.cli;

import io.gatling.plugin.BatchEnterprisePlugin;
import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.EnterprisePluginProvider;
import io.gatling.plugin.PluginConfiguration;
import io.gatling.plugin.cli.EnterpriseDeployOptions;
import io.gatling.plugin.cli.EnterpriseIO;
import io.gatling.plugin.cli.EnterprisePluginOptions;
import io.gatling.plugin.cli.EnterpriseStartOptions;
import io.gatling.plugin.deployment.DeploymentConfiguration;
import io.gatling.plugin.model.DeploymentInfo;
import io.gatling.plugin.model.RunSummary;
import java.io.File;

public class EnterpriseStart {
    public static void main(String[] stringArray) throws Exception {
        EnterpriseIO enterpriseIO = new EnterpriseIO();
        EnterprisePluginOptions enterprisePluginOptions = new EnterprisePluginOptions(enterpriseIO.logger);
        EnterpriseDeployOptions enterpriseDeployOptions = new EnterpriseDeployOptions();
        EnterpriseStartOptions enterpriseStartOptions = new EnterpriseStartOptions();
        PluginConfiguration pluginConfiguration = new PluginConfiguration(enterprisePluginOptions.apiUrl, enterprisePluginOptions.webAppUrl, enterprisePluginOptions.apiToken, enterprisePluginOptions.controlPlaneUrl, enterprisePluginOptions.buildTool, enterprisePluginOptions.pluginVersion, enterprisePluginOptions.batchMode, enterpriseIO.pluginIo);
        BatchEnterprisePlugin batchEnterprisePlugin = EnterprisePluginProvider.getBatchInstance(pluginConfiguration);
        File file = DeploymentConfiguration.fromBaseDirectory(enterpriseDeployOptions.baseDirectory, enterpriseDeployOptions.packageDescriptorFilename);
        DeploymentInfo deploymentInfo = batchEnterprisePlugin.deployFromDescriptor(file, enterpriseDeployOptions.packageFile, enterpriseDeployOptions.artifactId, enterprisePluginOptions.controlPlaneUrl != null);
        EnterprisePlugin enterprisePlugin = EnterprisePluginProvider.getInstance(pluginConfiguration);
        RunSummary runSummary = enterprisePlugin.startSimulation(enterpriseStartOptions.simulationName, deploymentInfo, enterpriseStartOptions.runComment);
        String string = enterprisePluginOptions.webAppUrl.toExternalForm() + runSummary.reportsPath;
        enterpriseIO.logger.info("Simulation successfully started.\nReports available at: " + string);
        if (enterpriseStartOptions.waitForRunEnd) {
            enterprisePlugin.waitForRunEnd(runSummary);
        }
    }
}

