/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.cli;

import io.gatling.plugin.ConfigurationConstants;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.model.BuildTool;
import java.net.URI;
import java.net.URL;

public class EnterprisePluginOptions {
    public final URL apiUrl = URI.create(ConfigurationConstants.ApiUrl.value()).toURL();
    public final URL webAppUrl = URI.create(ConfigurationConstants.WebAppUrl.value()).toURL();
    public final String apiToken = ConfigurationConstants.ApiToken.value();
    public final URL controlPlaneUrl;
    public final BuildTool buildTool;
    public final String pluginVersion;
    public final boolean batchMode;

    public EnterprisePluginOptions(PluginLogger pluginLogger) throws Exception {
        if (this.apiToken == null) {
            pluginLogger.error("An API token is required to call the Gatling Enterprise server; see https://docs.gatling.io/reference/execute/cloud/admin/api-tokens/ and create a token with the role 'Configurer'.\nYou can then set your API token's value in the environment variable GATLING_ENTERPRISE_API_TOKEN, or pass it with --api-token=<apiToken>.");
            throw new IllegalArgumentException("An API token is required to call the Gatling Enterprise server.");
        }
        String string = ConfigurationConstants.ControlPlaneUrl.value();
        this.controlPlaneUrl = string != null ? new URL(string) : null;
        this.buildTool = BuildTool.get(ConfigurationConstants.BuildTool.value());
        this.pluginVersion = ConfigurationConstants.PluginVersion.value();
        this.batchMode = ConfigurationConstants.BatchMode.value();
    }
}

