/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.util.cache;

import io.gatling.core.session.Session;
import io.gatling.core.util.cache.Cache;
import io.gatling.core.util.cache.Cache$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000594Aa\u0003\u0007\u0001/!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015y\u0003\u0001\"\u00011\u0011\u001d\u0019\u0005A1A\u0005\u0002\u0011Ca\u0001\u0013\u0001!\u0002\u0013)\u0005BB%\u0001\t\u0003a!\n\u0003\u0004Y\u0001\u0011\u0005A\"\u0017\u0005\u00067\u0002!\t\u0001\u0018\u0005\u0006E\u0002!\ta\u0019\u0005\u0006U\u0002!\ta\u001b\u0002\u0014'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.\u001a%b]\u0012dWM\u001d\u0006\u0003\u001b9\tQaY1dQ\u0016T!a\u0004\t\u0002\tU$\u0018\u000e\u001c\u0006\u0003#I\tAaY8sK*\u00111\u0003F\u0001\bO\u0006$H.\u001b8h\u0015\u0005)\u0012AA5p\u0007\u0001)2\u0001G\u001b@'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\nG\u0006\u001c\u0007.\u001a(b[\u0016\u0004\"!\t\u0015\u000f\u0005\t2\u0003CA\u0012\u001c\u001b\u0005!#BA\u0013\u0017\u0003\u0019a$o\\8u}%\u0011qeG\u0001\u0007!J,G-\u001a4\n\u0005%R#AB*ue&twM\u0003\u0002(7\u0005YQ.\u0019=DCB\f7-\u001b;z!\tQR&\u0003\u0002/7\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\r\t\u0014I\u0011\t\u0005e\u0001\u0019d(D\u0001\r!\t!T\u0007\u0004\u0001\u0005\u000bY\u0002!\u0019A\u001c\u0003\u0003-\u000b\"\u0001O\u001e\u0011\u0005iI\u0014B\u0001\u001e\u001c\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0007\u001f\n\u0005uZ\"aA!osB\u0011Ag\u0010\u0003\u0006\u0001\u0002\u0011\ra\u000e\u0002\u0002-\")qd\u0001a\u0001A!)1f\u0001a\u0001Y\u00059QM\\1cY\u0016$W#A#\u0011\u0005i1\u0015BA$\u001c\u0005\u001d\u0011un\u001c7fC:\f\u0001\"\u001a8bE2,G\rI\u0001\tO\u0016$8)Y2iKR\u00111*\u0015\t\u000451s\u0015BA'\u001c\u0005\u0019y\u0005\u000f^5p]B!!gT\u001a?\u0013\t\u0001FBA\u0003DC\u000eDW\rC\u0003S\r\u0001\u00071+A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005Q3V\"A+\u000b\u0005I\u0003\u0012BA,V\u0005\u001d\u0019Vm]:j_:\f\u0001cZ3u\u001fJ\u001c%/Z1uK\u000e\u000b7\r[3\u0015\u00059S\u0006\"\u0002*\b\u0001\u0004\u0019\u0016\u0001C1eI\u0016sGO]=\u0015\tMkf\f\u0019\u0005\u0006%\"\u0001\ra\u0015\u0005\u0006?\"\u0001\raM\u0001\u0004W\u0016L\b\"B1\t\u0001\u0004q\u0014!\u0002<bYV,\u0017\u0001C4fi\u0016sGO]=\u0015\u0007\u0011,g\rE\u0002\u001b\u0019zBQAU\u0005A\u0002MCaaX\u0005\u0005\u0002\u00049\u0007c\u0001\u000eig%\u0011\u0011n\u0007\u0002\ty\tLh.Y7f}\u0005Y!/Z7pm\u0016,e\u000e\u001e:z)\r\u0019F.\u001c\u0005\u0006%*\u0001\ra\u0015\u0005\u0006?*\u0001\ra\r")
public class SessionCacheHandler<K, V> {
    private final String cacheName;
    private final int maxCapacity;
    private final boolean enabled;

    public boolean enabled() {
        return this.enabled;
    }

    public Option<Cache<K, V>> getCache(Session session) {
        return session.attributes().get((Object)this.cacheName).map((Function1 & Serializable)x$1 -> (Cache)x$1);
    }

    public Cache<K, V> getOrCreateCache(Session session) {
        Option<Cache<K, V>> option = this.getCache(session);
        if (option instanceof Some) {
            Some some = (Some)option;
            Cache cache = (Cache)some.value();
            return cache;
        }
        return Cache$.MODULE$.newImmutableCache(this.maxCapacity);
    }

    public Session addEntry(Session session, K key, V value) {
        Cache<K, V> cache = this.getOrCreateCache(session);
        Cache<K, V> newCache = cache.put(key, value);
        if (newCache == cache) {
            return session;
        }
        return session.set(this.cacheName, newCache);
    }

    public Option<V> getEntry(Session session, Function0<K> key) {
        return this.getCache(session).flatMap((Function1 & Serializable)x$2 -> x$2.get(key.apply()));
    }

    public Session removeEntry(Session session, K key) {
        Option<Cache<K, V>> option = this.getCache(session);
        if (option instanceof Some) {
            Some some = (Some)option;
            Cache cache = (Cache)some.value();
            Cache newCache = cache.remove(key);
            if (newCache == cache) {
                return session;
            }
            return session.set(this.cacheName, newCache);
        }
        return session;
    }

    public SessionCacheHandler(String cacheName, int maxCapacity) {
        this.cacheName = cacheName;
        this.maxCapacity = maxCapacity;
        this.enabled = maxCapacity > 0;
    }
}

