/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public final class StringInternals {
    private static final MethodHandle coderMH;
    private static final MethodHandle valueMH;
    private static final MethodHandle newStringMH;
    private static final Throwable unavailabilityCause;

    private StringInternals() {
    }

    public static void checkAvailability() throws Throwable {
        if (unavailabilityCause != null) {
            throw unavailabilityCause;
        }
    }

    public static byte coder(String string) {
        try {
            return coderMH.invokeExact(string);
        }
        catch (Throwable throwable) {
            throw StringInternals.wrap(throwable);
        }
    }

    public static byte[] value(String string) {
        try {
            return valueMH.invokeExact(string);
        }
        catch (Throwable throwable) {
            throw StringInternals.wrap(throwable);
        }
    }

    public static String newString(byte[] byArray, byte by) {
        try {
            return newStringMH.invokeExact(byArray, by);
        }
        catch (Throwable throwable) {
            throw StringInternals.wrap(throwable);
        }
    }

    private static RuntimeException wrap(Throwable throwable) {
        return throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
    }

    static {
        Throwable throwable = null;
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        MethodHandle methodHandle3 = null;
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(String.class, MethodHandles.lookup());
            methodHandle = lookup.findVirtual(String.class, "coder", MethodType.methodType(Byte.TYPE));
            methodHandle2 = lookup.findVirtual(String.class, "value", MethodType.methodType(byte[].class));
            methodHandle3 = lookup.findConstructor(String.class, MethodType.methodType(Void.TYPE, byte[].class, Byte.TYPE));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        coderMH = methodHandle;
        valueMH = methodHandle2;
        newStringMH = methodHandle3;
        unavailabilityCause = throwable;
    }
}

