/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import io.gatling.core.controller.inject.open.AtOnceOpenInjection;
import io.gatling.core.controller.inject.open.ConstantRateOpenInjection;
import io.gatling.core.controller.inject.open.NothingForOpenInjection;
import io.gatling.core.controller.inject.open.OpenInjectionBuilder;
import io.gatling.core.controller.inject.open.RampRateOpenInjection;
import io.gatling.core.controller.inject.open.StairsUsersPerSecCompositeStep;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.OpenInjectionSteps;
import java.time.Duration;
import org.jspecify.annotations.NonNull;

public class OpenInjectionStep {
    private final io.gatling.core.controller.inject.open.OpenInjectionStep wrapped;

    private OpenInjectionStep(io.gatling.core.controller.inject.open.OpenInjectionStep openInjectionStep) {
        this.wrapped = openInjectionStep;
    }

    public static @NonNull OpenInjectionStep atOnceUsers(int n) {
        return new OpenInjectionStep((io.gatling.core.controller.inject.open.OpenInjectionStep)new AtOnceOpenInjection((long)n));
    }

    public static @NonNull OpenInjectionStep nothingFor(@NonNull Duration duration) {
        return new OpenInjectionStep((io.gatling.core.controller.inject.open.OpenInjectionStep)new NothingForOpenInjection(Converters.toScalaDuration(duration)));
    }

    public io.gatling.core.controller.inject.open.OpenInjectionStep asScala() {
        return this.wrapped;
    }

    public static final class Stairs {
        private final double rateIncrement;

        Stairs(double d) {
            this.rateIncrement = d;
        }

        public @NonNull Times times(int n) {
            return new Times(this.rateIncrement, n);
        }

        public static final class Times {
            private final double rateIncrement;
            private final int levels;

            private Times(double d, int n) {
                this.rateIncrement = d;
                this.levels = n;
            }

            public @NonNull Composite eachLevelLasting(long l) {
                return this.eachLevelLasting(Duration.ofSeconds(l));
            }

            public @NonNull Composite eachLevelLasting(@NonNull Duration duration) {
                return new Composite(OpenInjectionSteps.newEachLevelLasting(this.rateIncrement, this.levels).eachLevelLasting(Converters.toScalaDuration(duration)));
            }
        }

        public static final class Composite
        extends OpenInjectionStep {
            Composite(StairsUsersPerSecCompositeStep stairsUsersPerSecCompositeStep) {
                super((io.gatling.core.controller.inject.open.OpenInjectionStep)stairsUsersPerSecCompositeStep);
            }

            private StairsUsersPerSecCompositeStep wrapped() {
                return (StairsUsersPerSecCompositeStep)this.asScala();
            }

            public @NonNull Composite startingFrom(double d) {
                return new Composite(this.wrapped().startingFrom(d));
            }

            public @NonNull Composite separatedByRampsLasting(long l) {
                return this.separatedByRampsLasting(Duration.ofSeconds(l));
            }

            public @NonNull Composite separatedByRampsLasting(@NonNull Duration duration) {
                return new Composite(this.wrapped().separatedByRampsLasting(Converters.toScalaDuration(duration)));
            }
        }
    }

    public static final class RampRate {
        private final double from;

        RampRate(double d) {
            this.from = d;
        }

        public @NonNull During to(double d) {
            return new During(this.from, d);
        }

        public static final class During {
            private final double from;
            private final double to;

            private During(double d, double d2) {
                this.from = d;
                this.to = d2;
            }

            public @NonNull RampRateOpenInjectionStep during(long l) {
                return this.during(Duration.ofSeconds(l));
            }

            public @NonNull RampRateOpenInjectionStep during(@NonNull Duration duration) {
                return new RampRateOpenInjectionStep(OpenInjectionSteps.newRampRateTo(this.from, this.to).during(Converters.toScalaDuration(duration)));
            }
        }

        public static final class RampRateOpenInjectionStep
        extends OpenInjectionStep {
            private RampRateOpenInjectionStep(@NonNull RampRateOpenInjection rampRateOpenInjection) {
                super((io.gatling.core.controller.inject.open.OpenInjectionStep)rampRateOpenInjection);
            }

            public OpenInjectionStep randomized() {
                return new OpenInjectionStep(((RampRateOpenInjection)this.asScala()).randomized());
            }
        }
    }

    public static final class ConstantRate {
        private final OpenInjectionBuilder.ConstantRate wrapped;

        ConstantRate(double d) {
            this.wrapped = new OpenInjectionBuilder.ConstantRate(d);
        }

        public @NonNull ConstantRateOpenInjectionStep during(long l) {
            return this.during(Duration.ofSeconds(l));
        }

        public @NonNull ConstantRateOpenInjectionStep during(@NonNull Duration duration) {
            return new ConstantRateOpenInjectionStep(this.wrapped.during(Converters.toScalaDuration(duration)));
        }

        public static final class ConstantRateOpenInjectionStep
        extends OpenInjectionStep {
            private ConstantRateOpenInjectionStep(@NonNull ConstantRateOpenInjection constantRateOpenInjection) {
                super((io.gatling.core.controller.inject.open.OpenInjectionStep)constantRateOpenInjection);
            }

            public OpenInjectionStep randomized() {
                return new OpenInjectionStep(((ConstantRateOpenInjection)this.asScala()).randomized());
            }
        }
    }

    public static final class StressPeak {
        private final OpenInjectionBuilder.StressPeak wrapped;

        StressPeak(int n) {
            this.wrapped = new OpenInjectionBuilder.StressPeak(n);
        }

        public @NonNull OpenInjectionStep during(long l) {
            return this.during(Duration.ofSeconds(l));
        }

        public @NonNull OpenInjectionStep during(@NonNull Duration duration) {
            return new OpenInjectionStep(this.wrapped.during(Converters.toScalaDuration(duration)));
        }
    }

    public static final class Ramp {
        private final OpenInjectionBuilder.Ramp wrapped;

        Ramp(int n) {
            this.wrapped = new OpenInjectionBuilder.Ramp(n);
        }

        public @NonNull OpenInjectionStep during(long l) {
            return this.during(Duration.ofSeconds(l));
        }

        public @NonNull OpenInjectionStep during(@NonNull Duration duration) {
            return new OpenInjectionStep(this.wrapped.during(Converters.toScalaDuration(duration)));
        }
    }
}

