/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.stats.buffers;

import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.TDigest;
import io.gatling.charts.stats.Percentiles;
import io.gatling.charts.stats.PercentilesVsTimePlot;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005M3Qa\u0002\u0005\u0001\u0015IA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\u0006C\u0001!\tA\t\u0005\bM\u0001\u0011\r\u0011\"\u0001(\u0011\u00199\u0004\u0001)A\u0005Q!)\u0001\b\u0001C\u0001s!)\u0011\t\u0001C\u0001\u0005\n\u0011\u0002+\u001a:dK:$\u0018\u000e\\3t\u0005V4g-\u001a:t\u0015\tI!\"A\u0004ck\u001a4WM]:\u000b\u0005-a\u0011!B:uCR\u001c(BA\u0007\u000f\u0003\u0019\u0019\u0007.\u0019:ug*\u0011q\u0002E\u0001\bO\u0006$H.\u001b8h\u0015\u0005\t\u0012AA5p'\t\u00011\u0003\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VMZ\u0001\bEV\u001c7.\u001a;t\u0007\u0001\u00012\u0001\u0006\u000f\u001f\u0013\tiRCA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0015?%\u0011\u0001%\u0006\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\b\u0006\u0002$KA\u0011A\u0005A\u0007\u0002\u0011!)\u0011D\u0001a\u00017\u00059A-[4fgR\u001cX#\u0001\u0015\u0011\u0007Qa\u0012\u0006E\u0002\u0015U1J!aK\u000b\u0003\r=\u0003H/[8o!\tiS'D\u0001/\u0015\tYqF\u0003\u00021c\u0005!Q.\u0019;i\u0015\t\u00114'\u0001\u0005uIVtg.\u001b8h\u0015\u0005!\u0014aA2p[&\u0011aG\f\u0002\b)\u0012Kw-Z:u\u0003!!\u0017nZ3tiN\u0004\u0013AB;qI\u0006$X\rF\u0002;{}\u0002\"\u0001F\u001e\n\u0005q*\"\u0001B+oSRDQAP\u0003A\u0002y\tABY;dW\u0016$h*^7cKJDQ\u0001Q\u0003A\u0002y\tQA^1mk\u0016\f1\u0002]3sG\u0016tG/\u001b7fgV\t1\tE\u0002E\u0019>s!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!S\u0012A\u0002\u001fs_>$h(C\u0001\u0017\u0013\tYU#A\u0004qC\u000e\\\u0017mZ3\n\u00055s%aA*fc*\u00111*\u0006\t\u0003!Fk\u0011AC\u0005\u0003%*\u0011Q\u0003U3sG\u0016tG/\u001b7fgZ\u001bH+[7f!2|G\u000f")
public class PercentilesBuffers {
    private final int[] buckets;
    private final Option<TDigest>[] digests;

    public Option<TDigest>[] digests() {
        return this.digests;
    }

    public void update(int bucketNumber, int value) {
        Option<TDigest> option = this.digests()[bucketNumber];
        if (option instanceof Some) {
            Some some = (Some)option;
            TDigest digest = (TDigest)some.value();
            digest.add((double)value);
            return;
        }
        AVLTreeDigest digest = new AVLTreeDigest(100.0);
        digest.add((double)value);
        this.digests()[bucketNumber] = new Some((Object)digest);
    }

    public Seq<PercentilesVsTimePlot> percentiles() {
        return ((IterableOnceOps)((IterableOps)ArrayOps$.MODULE$.view$extension(Predef$.MODULE$.refArrayOps((Object[])this.digests())).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option digestO = (Option)tuple2._1();
                int bucketNumber = tuple2._2$mcI$sp();
                int time = $this.buckets[bucketNumber];
                Option percentiles = digestO.map((Function1 & Serializable)digest -> new Percentiles((int)digest.quantile(0.0), (int)digest.quantile(0.25), (int)digest.quantile(0.5), (int)digest.quantile(0.75), (int)digest.quantile(0.8), (int)digest.quantile(0.85), (int)digest.quantile(0.9), (int)digest.quantile(0.95), (int)digest.quantile(0.99), (int)digest.quantile(1.0)));
                return new PercentilesVsTimePlot(time, (Option<Percentiles>)percentiles);
            }
            throw new MatchError((Object)tuple2);
        })).toSeq();
    }

    public PercentilesBuffers(int[] buckets) {
        this.buckets = buckets;
        this.digests = (Option[])Array$.MODULE$.fill(buckets.length, (Function0 & Serializable)() -> None$.MODULE$, ClassTag$.MODULE$.apply(Option.class));
    }
}

