/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.utils;

import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class ScreenshotUtil {
    private static final Set<String> IGNORED_EXCEPTIONS = ImmutableSet.of((Object)"org.junit.AssumptionViolatedException", (Object)"org.junit.internal.AssumptionViolatedException", (Object)"org.testng.SkipException");

    private ScreenshotUtil() {
    }

    public static boolean isIgnoredException(Throwable e) {
        boolean isIgnored = false;
        if (e != null) {
            Class<?> clazz = e.getClass();
            do {
                if (!IGNORED_EXCEPTIONS.contains(clazz.getName())) continue;
                isIgnored = true;
                break;
            } while ((clazz = clazz.getSuperclass()) != Object.class);
        }
        return isIgnored;
    }
}

