/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.proxy;

import io.fluentlenium.core.proxy.AbstractLocatorAndInvocationHandler;
import io.fluentlenium.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class ComponentHandler
extends AbstractLocatorAndInvocationHandler<WebElement> {
    private static final Method GET_WRAPPED_ELEMENT = ReflectionUtils.getMethod(WrapsElement.class, "getWrappedElement", new Class[0]);

    public ComponentHandler(ElementLocator locator) {
        super(locator);
        if (this.locator instanceof WrapsElement) {
            this.fireProxyElementSearch();
            WebElement result = ((WrapsElement)this.locator).getWrappedElement();
            if (result == null) {
                throw this.noSuchElement();
            }
            this.result = result;
            this.fireProxyElementFound(result);
        }
    }

    @Override
    public String getMessageContext() {
        return "Element " + this.toString();
    }

    @Override
    protected List<WebElement> resultToList(WebElement result) {
        return Arrays.asList(result);
    }

    @Override
    protected boolean isStale() {
        try {
            ((WebElement)this.result).isEnabled();
            return false;
        }
        catch (StaleElementReferenceException e) {
            return true;
        }
    }

    @Override
    public WebElement getElement() {
        return (WebElement)this.result;
    }

    @Override
    public WebElement getLocatorResultImpl() {
        WebElement element;
        try {
            element = this.getHookLocator().findElement();
        }
        catch (NoSuchElementException e) {
            element = null;
        }
        if (element == null) {
            throw this.noSuchElement();
        }
        return element;
    }

    @Override
    public WebElement getInvocationTarget(Method method) {
        if (method != null && method.getDeclaringClass().equals(Object.class)) {
            return (WebElement)this.result;
        }
        if (this.getElement() == null) {
            return null;
        }
        if (this.hooks != null && !this.hooks.isEmpty()) {
            return (WebElement)this.hooks.get(this.hooks.size() - 1);
        }
        return this.getElement();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (GET_WRAPPED_ELEMENT.equals(method)) {
            return this.loaded() ? this.getLocatorResult() : proxy;
        }
        return super.invoke(proxy, method, args);
    }
}

