/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.inject;

import io.fluentlenium.core.hook.FluentHook;
import io.fluentlenium.core.hook.Hook;
import io.fluentlenium.core.hook.HookControlImpl;
import io.fluentlenium.core.hook.HookDefinition;
import io.fluentlenium.core.hook.HookOptions;
import io.fluentlenium.core.hook.NoHook;
import io.fluentlenium.core.inject.FluentInjectException;
import io.fluentlenium.core.inject.InjectionAnnotationSupport;
import io.fluentlenium.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

final class FluentInjectHookDefinitionAdder {
    FluentInjectHookDefinitionAdder() {
    }

    void addHookDefinitions(Annotation[] annotations, List<HookDefinition<?>> hookDefinitions) {
        Hook currentHookAnnotation = null;
        HookOptions currentHookOptionAnnotation = null;
        Annotation currentAnnotation = null;
        for (Annotation annotation : annotations) {
            this.applyNoHook(hookDefinitions, annotation);
            Hook hookAnnotation = this.getHookAnnotation(annotation);
            if (hookAnnotation != null) {
                currentAnnotation = annotation;
                if (currentHookAnnotation != null) {
                    hookDefinitions.add(this.buildHookDefinition(currentHookAnnotation, currentHookOptionAnnotation, currentAnnotation));
                    currentHookOptionAnnotation = null;
                }
                currentHookAnnotation = hookAnnotation;
            }
            currentHookOptionAnnotation = this.validateHookOptionsAnnotation(currentHookOptionAnnotation, annotation);
        }
        if (currentHookAnnotation != null) {
            hookDefinitions.add(this.buildHookDefinition(currentHookAnnotation, currentHookOptionAnnotation, currentAnnotation));
        }
    }

    private HookOptions validateHookOptionsAnnotation(HookOptions currentHookOptionAnnotation, Annotation annotation) {
        HookOptions hookOptionsAnnotation = this.getHookOptionsAnnotation(annotation);
        if (hookOptionsAnnotation != null) {
            if (currentHookOptionAnnotation != null) {
                throw new FluentInjectException("Unexpected @HookOptions annotation. @Hook is missing.");
            }
            currentHookOptionAnnotation = hookOptionsAnnotation;
        }
        return currentHookOptionAnnotation;
    }

    private Hook getHookAnnotation(Annotation annotation) {
        if (annotation instanceof Hook) {
            return (Hook)annotation;
        }
        if (InjectionAnnotationSupport.isAnnotationTypeHook(annotation)) {
            return annotation.annotationType().getAnnotation(Hook.class);
        }
        return null;
    }

    private HookOptions getHookOptionsAnnotation(Annotation annotation) {
        if (annotation instanceof HookOptions) {
            return (HookOptions)annotation;
        }
        if (InjectionAnnotationSupport.isAnnotationTypeHookOptions(annotation)) {
            return annotation.annotationType().getAnnotation(HookOptions.class);
        }
        return null;
    }

    private void applyNoHook(List<HookDefinition<?>> hookDefinitions, Annotation annotation) {
        if (annotation instanceof NoHook) {
            Object[] value = ((NoHook)annotation).value();
            if (ArrayUtils.isEmpty((Object[])value)) {
                hookDefinitions.clear();
            } else {
                HookControlImpl.removeHooksFromDefinitions(hookDefinitions, (Class[])Arrays.stream(value).map(Hook::value).toArray(Class[]::new));
            }
        }
    }

    private <T> HookDefinition<T> buildHookDefinition(Hook hookAnnotation, HookOptions hookOptionsAnnotation, Annotation currentAnnotation) {
        Class<?> hookOptionsClass = hookOptionsAnnotation == null ? null : hookOptionsAnnotation.value();
        Object fluentHookOptions = null;
        if (hookOptionsClass != null) {
            try {
                fluentHookOptions = ReflectionUtils.newInstanceOptionalArgs(hookOptionsClass, currentAnnotation);
            }
            catch (NoSuchMethodException e) {
                throw new FluentInjectException("@HookOption class has no valid constructor", e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new FluentInjectException("Can't create @HookOption class instance", e);
            }
        }
        Class<? extends FluentHook<?>> hookClass = hookAnnotation.value();
        return fluentHookOptions == null ? new HookDefinition(hookClass) : new HookDefinition<Object>((Class<FluentHook<Object>>)hookClass, fluentHookOptions);
    }
}

