/*
 * Decompiled with CFR 0.152.
 */
package io.fluentlenium.core.hook;

import io.fluentlenium.core.FluentControl;
import io.fluentlenium.core.components.ComponentInstantiator;
import io.fluentlenium.core.hook.DefaultHookChainBuilder;
import io.fluentlenium.core.hook.FluentHook;
import io.fluentlenium.core.hook.HookChainBuilder;
import io.fluentlenium.core.hook.HookControl;
import io.fluentlenium.core.hook.HookDefinition;
import io.fluentlenium.core.proxy.LocatorProxies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Supplier;

public class HookControlImpl<T>
implements HookControl<T> {
    private final List<HookDefinition<?>> hookDefinitions = new ArrayList();
    private Stack<List<HookDefinition<?>>> hookRestoreStack = new Stack();
    private final HookChainBuilder hookChainBuilder;
    private final T self;
    private final Object proxy;
    private final Supplier<T> noHookInstanceSupplier;

    public HookControlImpl(T self, Object proxy, FluentControl control, ComponentInstantiator instantiator, Supplier<T> noHookInstanceSupplier) {
        this.self = self;
        this.proxy = proxy;
        this.noHookInstanceSupplier = noHookInstanceSupplier;
        this.hookChainBuilder = new DefaultHookChainBuilder(control, instantiator);
    }

    public List<HookDefinition<?>> getHookDefinitions() {
        return this.hookDefinitions;
    }

    public Stack<List<HookDefinition<?>>> getHookRestoreStack() {
        return this.hookRestoreStack;
    }

    public void setHookRestoreStack(Stack<List<HookDefinition<?>>> hookRestoreStack) {
        this.hookRestoreStack = hookRestoreStack;
    }

    public static void removeHooksFromDefinitions(Collection<HookDefinition<?>> definitions, Class<? extends FluentHook> ... hooksToRemove) {
        Iterator<HookDefinition<?>> hookDefinitionsIterator = definitions.iterator();
        List<Class<? extends FluentHook>> toRemoveHooks = Arrays.asList(hooksToRemove);
        while (hookDefinitionsIterator.hasNext()) {
            HookDefinition<?> next = hookDefinitionsIterator.next();
            if (!toRemoveHooks.contains(next.getHookClass())) continue;
            hookDefinitionsIterator.remove();
        }
    }

    private void backupHookDefinitions() {
        this.hookRestoreStack.add(new ArrayList(this.hookDefinitions));
    }

    private void restoreHookDefinitions() {
        if (!this.hookRestoreStack.isEmpty()) {
            List<HookDefinition<?>> pop = this.hookRestoreStack.pop();
            this.hookDefinitions.clear();
            this.hookDefinitions.addAll(pop);
        }
    }

    @Override
    public T restoreHooks() {
        this.restoreHookDefinitions();
        this.applyHooks(this.proxy, this.hookChainBuilder, this.hookDefinitions);
        return this.self;
    }

    @Override
    public <O, H extends FluentHook<O>> T withHook(Class<H> hook) {
        this.hookDefinitions.add(new HookDefinition(hook));
        this.backupHookDefinitions();
        this.applyHooks(this.proxy, this.hookChainBuilder, this.hookDefinitions);
        return this.self;
    }

    @Override
    public <O, H extends FluentHook<O>> T withHook(Class<H> hook, O options) {
        this.hookDefinitions.add(new HookDefinition<O>(hook, options));
        this.backupHookDefinitions();
        this.applyHooks(this.proxy, this.hookChainBuilder, this.hookDefinitions);
        return this.self;
    }

    @Override
    public T noHook() {
        this.backupHookDefinitions();
        this.hookDefinitions.clear();
        this.applyHooks(this.proxy, this.hookChainBuilder, this.hookDefinitions);
        return this.self;
    }

    @Override
    public T noHook(Class<? extends FluentHook> ... hooks) {
        this.backupHookDefinitions();
        HookControlImpl.removeHooksFromDefinitions(this.hookDefinitions, hooks);
        this.applyHooks(this.proxy, this.hookChainBuilder, this.hookDefinitions);
        return this.self;
    }

    protected void applyHooks(Object proxy, HookChainBuilder hookChainBuilder, List<HookDefinition<?>> hookDefinitions) {
        LocatorProxies.setHooks(proxy, hookChainBuilder, hookDefinitions);
    }

    @Override
    public <R> R noHook(Function<T, R> function) {
        this.noHook();
        R functionReturn = function.apply(this.self);
        this.restoreHooks();
        return functionReturn;
    }

    @Override
    public <R> R noHook(Class<? extends FluentHook> hook, Function<T, R> function) {
        this.noHook(hook);
        R functionReturn = function.apply(this.self);
        this.restoreHooks();
        return functionReturn;
    }

    @Override
    public T noHookInstance() {
        return ((HookControl)this.noHookInstanceSupplier.get()).noHook();
    }

    @Override
    public T noHookInstance(Class<? extends FluentHook> ... hooks) {
        HookControl hookControl = (HookControl)this.noHookInstanceSupplier.get();
        for (HookDefinition<?> definition : this.hookDefinitions) {
            hookControl.withHook(definition.getHookClass(), definition.getOptions());
        }
        return hookControl.noHook(hooks);
    }
}

