/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.tekton.pipeline.v1alpha1.TaskRunInputs;
import io.fabric8.tekton.pipeline.v1alpha1.TaskRunInputsBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.TaskRunInputsFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.TaskRunOutputs;
import io.fabric8.tekton.pipeline.v1alpha1.TaskRunOutputsBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.TaskRunOutputsFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.TaskRunSpec;
import io.fabric8.tekton.pipeline.v1alpha1.TaskRunSpecFluent;
import io.fabric8.tekton.pipeline.v1alpha1.TaskSpec;
import io.fabric8.tekton.pipeline.v1alpha1.TaskSpecBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.TaskSpecFluentImpl;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.pod.Template;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.pod.TemplateBuilder;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.pod.TemplateFluentImpl;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.TaskRef;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.TaskRefBuilder;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.TaskRefFluentImpl;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.WorkspaceBinding;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.WorkspaceBindingBuilder;
import io.fabric8.tekton.v1alpha1.internal.pipeline.pkg.apis.pipeline.v1alpha2.WorkspaceBindingFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TaskRunSpecFluentImpl<A extends TaskRunSpecFluent<A>>
extends BaseFluent<A>
implements TaskRunSpecFluent<A> {
    private TaskRunInputsBuilder inputs;
    private TaskRunOutputsBuilder outputs;
    private TemplateBuilder podTemplate;
    private String serviceAccountName;
    private String status;
    private TaskRefBuilder taskRef;
    private TaskSpecBuilder taskSpec;
    private Duration timeout;
    private List<WorkspaceBindingBuilder> workspaces;

    public TaskRunSpecFluentImpl() {
    }

    public TaskRunSpecFluentImpl(TaskRunSpec instance) {
        this.withInputs(instance.getInputs());
        this.withOutputs(instance.getOutputs());
        this.withPodTemplate(instance.getPodTemplate());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withStatus(instance.getStatus());
        this.withTaskRef(instance.getTaskRef());
        this.withTaskSpec(instance.getTaskSpec());
        this.withTimeout(instance.getTimeout());
        this.withWorkspaces(instance.getWorkspaces());
    }

    @Override
    @Deprecated
    public TaskRunInputs getInputs() {
        return this.inputs != null ? this.inputs.build() : null;
    }

    @Override
    public TaskRunInputs buildInputs() {
        return this.inputs != null ? this.inputs.build() : null;
    }

    @Override
    public A withInputs(TaskRunInputs inputs) {
        this._visitables.get((Object)"inputs").remove(this.inputs);
        if (inputs != null) {
            this.inputs = new TaskRunInputsBuilder(inputs);
            this._visitables.get((Object)"inputs").add(this.inputs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInputs() {
        return this.inputs != null;
    }

    @Override
    public TaskRunSpecFluent.InputsNested<A> withNewInputs() {
        return new InputsNestedImpl();
    }

    @Override
    public TaskRunSpecFluent.InputsNested<A> withNewInputsLike(TaskRunInputs item) {
        return new InputsNestedImpl(item);
    }

    @Override
    public TaskRunSpecFluent.InputsNested<A> editInputs() {
        return this.withNewInputsLike(this.getInputs());
    }

    @Override
    public TaskRunSpecFluent.InputsNested<A> editOrNewInputs() {
        return this.withNewInputsLike(this.getInputs() != null ? this.getInputs() : new TaskRunInputsBuilder().build());
    }

    @Override
    public TaskRunSpecFluent.InputsNested<A> editOrNewInputsLike(TaskRunInputs item) {
        return this.withNewInputsLike(this.getInputs() != null ? this.getInputs() : item);
    }

    @Override
    @Deprecated
    public TaskRunOutputs getOutputs() {
        return this.outputs != null ? this.outputs.build() : null;
    }

    @Override
    public TaskRunOutputs buildOutputs() {
        return this.outputs != null ? this.outputs.build() : null;
    }

    @Override
    public A withOutputs(TaskRunOutputs outputs) {
        this._visitables.get((Object)"outputs").remove(this.outputs);
        if (outputs != null) {
            this.outputs = new TaskRunOutputsBuilder(outputs);
            this._visitables.get((Object)"outputs").add(this.outputs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutputs() {
        return this.outputs != null;
    }

    @Override
    public TaskRunSpecFluent.OutputsNested<A> withNewOutputs() {
        return new OutputsNestedImpl();
    }

    @Override
    public TaskRunSpecFluent.OutputsNested<A> withNewOutputsLike(TaskRunOutputs item) {
        return new OutputsNestedImpl(item);
    }

    @Override
    public TaskRunSpecFluent.OutputsNested<A> editOutputs() {
        return this.withNewOutputsLike(this.getOutputs());
    }

    @Override
    public TaskRunSpecFluent.OutputsNested<A> editOrNewOutputs() {
        return this.withNewOutputsLike(this.getOutputs() != null ? this.getOutputs() : new TaskRunOutputsBuilder().build());
    }

    @Override
    public TaskRunSpecFluent.OutputsNested<A> editOrNewOutputsLike(TaskRunOutputs item) {
        return this.withNewOutputsLike(this.getOutputs() != null ? this.getOutputs() : item);
    }

    @Override
    @Deprecated
    public Template getPodTemplate() {
        return this.podTemplate != null ? this.podTemplate.build() : null;
    }

    @Override
    public Template buildPodTemplate() {
        return this.podTemplate != null ? this.podTemplate.build() : null;
    }

    @Override
    public A withPodTemplate(Template podTemplate) {
        this._visitables.get((Object)"podTemplate").remove(this.podTemplate);
        if (podTemplate != null) {
            this.podTemplate = new TemplateBuilder(podTemplate);
            this._visitables.get((Object)"podTemplate").add(this.podTemplate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodTemplate() {
        return this.podTemplate != null;
    }

    @Override
    public TaskRunSpecFluent.PodTemplateNested<A> withNewPodTemplate() {
        return new PodTemplateNestedImpl();
    }

    @Override
    public TaskRunSpecFluent.PodTemplateNested<A> withNewPodTemplateLike(Template item) {
        return new PodTemplateNestedImpl(item);
    }

    @Override
    public TaskRunSpecFluent.PodTemplateNested<A> editPodTemplate() {
        return this.withNewPodTemplateLike(this.getPodTemplate());
    }

    @Override
    public TaskRunSpecFluent.PodTemplateNested<A> editOrNewPodTemplate() {
        return this.withNewPodTemplateLike(this.getPodTemplate() != null ? this.getPodTemplate() : new TemplateBuilder().build());
    }

    @Override
    public TaskRunSpecFluent.PodTemplateNested<A> editOrNewPodTemplateLike(Template item) {
        return this.withNewPodTemplateLike(this.getPodTemplate() != null ? this.getPodTemplate() : item);
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    @Deprecated
    public A withNewServiceAccountName(String arg0) {
        return this.withServiceAccountName(new String(arg0));
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public A withStatus(String status) {
        this.status = status;
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    @Deprecated
    public A withNewStatus(String arg0) {
        return this.withStatus(new String(arg0));
    }

    @Override
    @Deprecated
    public TaskRef getTaskRef() {
        return this.taskRef != null ? this.taskRef.build() : null;
    }

    @Override
    public TaskRef buildTaskRef() {
        return this.taskRef != null ? this.taskRef.build() : null;
    }

    @Override
    public A withTaskRef(TaskRef taskRef) {
        this._visitables.get((Object)"taskRef").remove(this.taskRef);
        if (taskRef != null) {
            this.taskRef = new TaskRefBuilder(taskRef);
            this._visitables.get((Object)"taskRef").add(this.taskRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTaskRef() {
        return this.taskRef != null;
    }

    @Override
    public A withNewTaskRef(String apiVersion, String kind, String name) {
        return this.withTaskRef(new TaskRef(apiVersion, kind, name));
    }

    @Override
    public TaskRunSpecFluent.TaskRefNested<A> withNewTaskRef() {
        return new TaskRefNestedImpl();
    }

    @Override
    public TaskRunSpecFluent.TaskRefNested<A> withNewTaskRefLike(TaskRef item) {
        return new TaskRefNestedImpl(item);
    }

    @Override
    public TaskRunSpecFluent.TaskRefNested<A> editTaskRef() {
        return this.withNewTaskRefLike(this.getTaskRef());
    }

    @Override
    public TaskRunSpecFluent.TaskRefNested<A> editOrNewTaskRef() {
        return this.withNewTaskRefLike(this.getTaskRef() != null ? this.getTaskRef() : new TaskRefBuilder().build());
    }

    @Override
    public TaskRunSpecFluent.TaskRefNested<A> editOrNewTaskRefLike(TaskRef item) {
        return this.withNewTaskRefLike(this.getTaskRef() != null ? this.getTaskRef() : item);
    }

    @Override
    @Deprecated
    public TaskSpec getTaskSpec() {
        return this.taskSpec != null ? this.taskSpec.build() : null;
    }

    @Override
    public TaskSpec buildTaskSpec() {
        return this.taskSpec != null ? this.taskSpec.build() : null;
    }

    @Override
    public A withTaskSpec(TaskSpec taskSpec) {
        this._visitables.get((Object)"taskSpec").remove(this.taskSpec);
        if (taskSpec != null) {
            this.taskSpec = new TaskSpecBuilder(taskSpec);
            this._visitables.get((Object)"taskSpec").add(this.taskSpec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTaskSpec() {
        return this.taskSpec != null;
    }

    @Override
    public TaskRunSpecFluent.TaskSpecNested<A> withNewTaskSpec() {
        return new TaskSpecNestedImpl();
    }

    @Override
    public TaskRunSpecFluent.TaskSpecNested<A> withNewTaskSpecLike(TaskSpec item) {
        return new TaskSpecNestedImpl(item);
    }

    @Override
    public TaskRunSpecFluent.TaskSpecNested<A> editTaskSpec() {
        return this.withNewTaskSpecLike(this.getTaskSpec());
    }

    @Override
    public TaskRunSpecFluent.TaskSpecNested<A> editOrNewTaskSpec() {
        return this.withNewTaskSpecLike(this.getTaskSpec() != null ? this.getTaskSpec() : new TaskSpecBuilder().build());
    }

    @Override
    public TaskRunSpecFluent.TaskSpecNested<A> editOrNewTaskSpecLike(TaskSpec item) {
        return this.withNewTaskSpecLike(this.getTaskSpec() != null ? this.getTaskSpec() : item);
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public A withTimeout(Duration timeout) {
        this.timeout = timeout;
        return (A)this;
    }

    @Override
    public Boolean hasTimeout() {
        return this.timeout != null;
    }

    @Override
    public A addToWorkspaces(Integer index, WorkspaceBinding item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList<WorkspaceBindingBuilder>();
        }
        WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
        this._visitables.get((Object)"workspaces").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"workspaces").size(), builder);
        this.workspaces.add(index >= 0 ? index.intValue() : this.workspaces.size(), builder);
        return (A)this;
    }

    @Override
    public A setToWorkspaces(Integer index, WorkspaceBinding item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList<WorkspaceBindingBuilder>();
        }
        WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"workspaces").size()) {
            this._visitables.get((Object)"workspaces").add(builder);
        } else {
            this._visitables.get((Object)"workspaces").set(index, builder);
        }
        if (index < 0 || index >= this.workspaces.size()) {
            this.workspaces.add(builder);
        } else {
            this.workspaces.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToWorkspaces(WorkspaceBinding ... items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList<WorkspaceBindingBuilder>();
        }
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToWorkspaces(Collection<WorkspaceBinding> items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList<WorkspaceBindingBuilder>();
        }
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromWorkspaces(WorkspaceBinding ... items) {
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").remove(builder);
            if (this.workspaces == null) continue;
            this.workspaces.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWorkspaces(Collection<WorkspaceBinding> items) {
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").remove(builder);
            if (this.workspaces == null) continue;
            this.workspaces.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromWorkspaces(Predicate<WorkspaceBindingBuilder> predicate) {
        if (this.workspaces == null) {
            return (A)this;
        }
        Iterator<WorkspaceBindingBuilder> each = this.workspaces.iterator();
        List visitables = this._visitables.get((Object)"workspaces");
        while (each.hasNext()) {
            WorkspaceBindingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<WorkspaceBinding> getWorkspaces() {
        return TaskRunSpecFluentImpl.build(this.workspaces);
    }

    @Override
    public List<WorkspaceBinding> buildWorkspaces() {
        return TaskRunSpecFluentImpl.build(this.workspaces);
    }

    @Override
    public WorkspaceBinding buildWorkspace(Integer index) {
        return this.workspaces.get(index).build();
    }

    @Override
    public WorkspaceBinding buildFirstWorkspace() {
        return this.workspaces.get(0).build();
    }

    @Override
    public WorkspaceBinding buildLastWorkspace() {
        return this.workspaces.get(this.workspaces.size() - 1).build();
    }

    @Override
    public WorkspaceBinding buildMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
        for (WorkspaceBindingBuilder item : this.workspaces) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
        for (WorkspaceBindingBuilder item : this.workspaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWorkspaces(List<WorkspaceBinding> workspaces) {
        if (this.workspaces != null) {
            this._visitables.get((Object)"workspaces").removeAll(this.workspaces);
        }
        if (workspaces != null) {
            this.workspaces = new ArrayList<WorkspaceBindingBuilder>();
            for (WorkspaceBinding item : workspaces) {
                this.addToWorkspaces(item);
            }
        } else {
            this.workspaces = null;
        }
        return (A)this;
    }

    @Override
    public A withWorkspaces(WorkspaceBinding ... workspaces) {
        if (this.workspaces != null) {
            this.workspaces.clear();
        }
        if (workspaces != null) {
            for (WorkspaceBinding item : workspaces) {
                this.addToWorkspaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWorkspaces() {
        return this.workspaces != null && !this.workspaces.isEmpty();
    }

    @Override
    public TaskRunSpecFluent.WorkspacesNested<A> addNewWorkspace() {
        return new WorkspacesNestedImpl();
    }

    @Override
    public TaskRunSpecFluent.WorkspacesNested<A> addNewWorkspaceLike(WorkspaceBinding item) {
        return new WorkspacesNestedImpl(-1, item);
    }

    @Override
    public TaskRunSpecFluent.WorkspacesNested<A> setNewWorkspaceLike(Integer index, WorkspaceBinding item) {
        return new WorkspacesNestedImpl(index, item);
    }

    @Override
    public TaskRunSpecFluent.WorkspacesNested<A> editWorkspace(Integer index) {
        if (this.workspaces.size() <= index) {
            throw new RuntimeException("Can't edit workspaces. Index exceeds size.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    @Override
    public TaskRunSpecFluent.WorkspacesNested<A> editFirstWorkspace() {
        if (this.workspaces.size() == 0) {
            throw new RuntimeException("Can't edit first workspaces. The list is empty.");
        }
        return this.setNewWorkspaceLike(0, this.buildWorkspace(0));
    }

    @Override
    public TaskRunSpecFluent.WorkspacesNested<A> editLastWorkspace() {
        int index = this.workspaces.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last workspaces. The list is empty.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    @Override
    public TaskRunSpecFluent.WorkspacesNested<A> editMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.workspaces.size(); ++i) {
            if (!predicate.test(this.workspaces.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching workspaces. No match found.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskRunSpecFluentImpl that = (TaskRunSpecFluentImpl)o;
        if (this.inputs != null ? !this.inputs.equals(that.inputs) : that.inputs != null) {
            return false;
        }
        if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) {
            return false;
        }
        if (this.podTemplate != null ? !this.podTemplate.equals(that.podTemplate) : that.podTemplate != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.taskRef != null ? !this.taskRef.equals(that.taskRef) : that.taskRef != null) {
            return false;
        }
        if (this.taskSpec != null ? !this.taskSpec.equals(that.taskSpec) : that.taskSpec != null) {
            return false;
        }
        if (this.timeout != null ? !this.timeout.equals((Object)that.timeout) : that.timeout != null) {
            return false;
        }
        return !(this.workspaces != null ? !this.workspaces.equals(that.workspaces) : that.workspaces != null);
    }

    public int hashCode() {
        return Objects.hash(this.inputs, this.outputs, this.podTemplate, this.serviceAccountName, this.status, this.taskRef, this.taskSpec, this.timeout, this.workspaces, super.hashCode());
    }

    public class WorkspacesNestedImpl<N>
    extends WorkspaceBindingFluentImpl<TaskRunSpecFluent.WorkspacesNested<N>>
    implements TaskRunSpecFluent.WorkspacesNested<N>,
    Nested<N> {
        WorkspaceBindingBuilder builder;
        Integer index;

        WorkspacesNestedImpl(Integer index, WorkspaceBinding item) {
            this.index = index;
            this.builder = new WorkspaceBindingBuilder(this, item);
        }

        WorkspacesNestedImpl() {
            this.index = -1;
            this.builder = new WorkspaceBindingBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunSpecFluentImpl.this.setToWorkspaces(this.index, this.builder.build());
        }

        @Override
        public N endWorkspace() {
            return this.and();
        }
    }

    public class TaskSpecNestedImpl<N>
    extends TaskSpecFluentImpl<TaskRunSpecFluent.TaskSpecNested<N>>
    implements TaskRunSpecFluent.TaskSpecNested<N>,
    Nested<N> {
        TaskSpecBuilder builder;

        TaskSpecNestedImpl(TaskSpec item) {
            this.builder = new TaskSpecBuilder(this, item);
        }

        TaskSpecNestedImpl() {
            this.builder = new TaskSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunSpecFluentImpl.this.withTaskSpec(this.builder.build());
        }

        @Override
        public N endTaskSpec() {
            return this.and();
        }
    }

    public class TaskRefNestedImpl<N>
    extends TaskRefFluentImpl<TaskRunSpecFluent.TaskRefNested<N>>
    implements TaskRunSpecFluent.TaskRefNested<N>,
    Nested<N> {
        TaskRefBuilder builder;

        TaskRefNestedImpl(TaskRef item) {
            this.builder = new TaskRefBuilder(this, item);
        }

        TaskRefNestedImpl() {
            this.builder = new TaskRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunSpecFluentImpl.this.withTaskRef(this.builder.build());
        }

        @Override
        public N endTaskRef() {
            return this.and();
        }
    }

    public class PodTemplateNestedImpl<N>
    extends TemplateFluentImpl<TaskRunSpecFluent.PodTemplateNested<N>>
    implements TaskRunSpecFluent.PodTemplateNested<N>,
    Nested<N> {
        TemplateBuilder builder;

        PodTemplateNestedImpl(Template item) {
            this.builder = new TemplateBuilder(this, item);
        }

        PodTemplateNestedImpl() {
            this.builder = new TemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunSpecFluentImpl.this.withPodTemplate(this.builder.build());
        }

        @Override
        public N endPodTemplate() {
            return this.and();
        }
    }

    public class OutputsNestedImpl<N>
    extends TaskRunOutputsFluentImpl<TaskRunSpecFluent.OutputsNested<N>>
    implements TaskRunSpecFluent.OutputsNested<N>,
    Nested<N> {
        TaskRunOutputsBuilder builder;

        OutputsNestedImpl(TaskRunOutputs item) {
            this.builder = new TaskRunOutputsBuilder(this, item);
        }

        OutputsNestedImpl() {
            this.builder = new TaskRunOutputsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunSpecFluentImpl.this.withOutputs(this.builder.build());
        }

        @Override
        public N endOutputs() {
            return this.and();
        }
    }

    public class InputsNestedImpl<N>
    extends TaskRunInputsFluentImpl<TaskRunSpecFluent.InputsNested<N>>
    implements TaskRunSpecFluent.InputsNested<N>,
    Nested<N> {
        TaskRunInputsBuilder builder;

        InputsNestedImpl(TaskRunInputs item) {
            this.builder = new TaskRunInputsBuilder(this, item);
        }

        InputsNestedImpl() {
            this.builder = new TaskRunInputsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskRunSpecFluentImpl.this.withInputs(this.builder.build());
        }

        @Override
        public N endInputs() {
            return this.and();
        }
    }
}

