/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.Task;
import io.fabric8.tekton.pipeline.v1alpha1.TaskFluent;
import io.fabric8.tekton.pipeline.v1alpha1.TaskFluentImpl;
import java.util.Objects;

public class TaskBuilder
extends TaskFluentImpl<TaskBuilder>
implements VisitableBuilder<Task, TaskBuilder> {
    TaskFluent<?> fluent;
    Boolean validationEnabled;

    public TaskBuilder() {
        this(false);
    }

    public TaskBuilder(Boolean validationEnabled) {
        this(new Task(), validationEnabled);
    }

    public TaskBuilder(TaskFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public TaskBuilder(TaskFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Task(), validationEnabled);
    }

    public TaskBuilder(TaskFluent<?> fluent, Task instance) {
        this(fluent, instance, false);
    }

    public TaskBuilder(TaskFluent<?> fluent, Task instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public TaskBuilder(Task instance) {
        this(instance, (Boolean)false);
    }

    public TaskBuilder(Task instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public Task build() {
        Task buildable = new Task(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskBuilder that = (TaskBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

