package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkspaceUsageBuilder extends WorkspaceUsageFluentImpl<WorkspaceUsageBuilder> implements VisitableBuilder<WorkspaceUsage,WorkspaceUsageBuilder>{
  public WorkspaceUsageBuilder() {
    this(false);
  }
  public WorkspaceUsageBuilder(Boolean validationEnabled) {
    this(new WorkspaceUsage(), validationEnabled);
  }
  public WorkspaceUsageBuilder(WorkspaceUsageFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkspaceUsageBuilder(WorkspaceUsageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkspaceUsage(), validationEnabled);
  }
  public WorkspaceUsageBuilder(WorkspaceUsageFluent<?> fluent,WorkspaceUsage instance) {
    this(fluent, instance, false);
  }
  public WorkspaceUsageBuilder(WorkspaceUsageFluent<?> fluent,WorkspaceUsage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMountPath(instance.getMountPath());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WorkspaceUsageBuilder(WorkspaceUsage instance) {
    this(instance,false);
  }
  public WorkspaceUsageBuilder(WorkspaceUsage instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMountPath(instance.getMountPath());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  WorkspaceUsageFluent<?> fluent;
  Boolean validationEnabled;
  public WorkspaceUsage build() {
    WorkspaceUsage buildable = new WorkspaceUsage(fluent.getMountPath(),fluent.getName());
    return buildable;
  }
  
}