package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkspaceDeclarationBuilder extends WorkspaceDeclarationFluentImpl<WorkspaceDeclarationBuilder> implements VisitableBuilder<WorkspaceDeclaration,WorkspaceDeclarationBuilder>{
  public WorkspaceDeclarationBuilder() {
    this(false);
  }
  public WorkspaceDeclarationBuilder(Boolean validationEnabled) {
    this(new WorkspaceDeclaration(), validationEnabled);
  }
  public WorkspaceDeclarationBuilder(WorkspaceDeclarationFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkspaceDeclarationBuilder(WorkspaceDeclarationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkspaceDeclaration(), validationEnabled);
  }
  public WorkspaceDeclarationBuilder(WorkspaceDeclarationFluent<?> fluent,WorkspaceDeclaration instance) {
    this(fluent, instance, false);
  }
  public WorkspaceDeclarationBuilder(WorkspaceDeclarationFluent<?> fluent,WorkspaceDeclaration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withMountPath(instance.getMountPath());
      fluent.withName(instance.getName());
      fluent.withOptional(instance.getOptional());
      fluent.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WorkspaceDeclarationBuilder(WorkspaceDeclaration instance) {
    this(instance,false);
  }
  public WorkspaceDeclarationBuilder(WorkspaceDeclaration instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withMountPath(instance.getMountPath());
      this.withName(instance.getName());
      this.withOptional(instance.getOptional());
      this.withReadOnly(instance.getReadOnly());
    }
    this.validationEnabled = validationEnabled; 
  }
  WorkspaceDeclarationFluent<?> fluent;
  Boolean validationEnabled;
  public WorkspaceDeclaration build() {
    WorkspaceDeclaration buildable = new WorkspaceDeclaration(fluent.getDescription(),fluent.getMountPath(),fluent.getName(),fluent.getOptional(),fluent.getReadOnly());
    return buildable;
  }
  
}