package io.fabric8.tekton.pipeline.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.CSIVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ProjectedVolumeSource;

 /**
  * Generated
  */
public interface WorkspaceBindingFluent<A extends WorkspaceBindingFluent<A>> extends Fluent<A>{
  public ConfigMapVolumeSource getConfigMap();
  public A withConfigMap(ConfigMapVolumeSource configMap);
  public Boolean hasConfigMap();
  public CSIVolumeSource getCsi();
  public A withCsi(CSIVolumeSource csi);
  public Boolean hasCsi();
  public EmptyDirVolumeSource getEmptyDir();
  public A withEmptyDir(EmptyDirVolumeSource emptyDir);
  public Boolean hasEmptyDir();
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim();
  public A withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim);
  public Boolean hasPersistentVolumeClaim();
  public A withNewPersistentVolumeClaim(String claimName,Boolean readOnly);
  public ProjectedVolumeSource getProjected();
  public A withProjected(ProjectedVolumeSource projected);
  public Boolean hasProjected();
  public SecretVolumeSource getSecret();
  public A withSecret(SecretVolumeSource secret);
  public Boolean hasSecret();
  public String getSubPath();
  public A withSubPath(String subPath);
  public Boolean hasSubPath();
  
  /**
   * This method has been deprecated, please use method buildVolumeClaimTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PersistentVolumeClaim getVolumeClaimTemplate();
  public PersistentVolumeClaim buildVolumeClaimTemplate();
  public A withVolumeClaimTemplate(PersistentVolumeClaim volumeClaimTemplate);
  public Boolean hasVolumeClaimTemplate();
  public WorkspaceBindingFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplate();
  public WorkspaceBindingFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplateLike(PersistentVolumeClaim item);
  public WorkspaceBindingFluent.VolumeClaimTemplateNested<A> editVolumeClaimTemplate();
  public WorkspaceBindingFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplate();
  public WorkspaceBindingFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplateLike(PersistentVolumeClaim item);
  public interface VolumeClaimTemplateNested<N> extends Nested<N>,PersistentVolumeClaimFluent<WorkspaceBindingFluent.VolumeClaimTemplateNested<N>>{
    public N and();
    public N endVolumeClaimTemplate();
    
  }
  
}