package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.Collection;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import java.util.Iterator;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TaskSpecFluentImpl<A extends TaskSpecFluent<A>> extends BaseFluent<A> implements TaskSpecFluent<A>{
  public TaskSpecFluentImpl() {
  }
  public TaskSpecFluentImpl(TaskSpec instance) {
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withParams(instance.getParams());
      this.withResults(instance.getResults());
      this.withSidecars(instance.getSidecars());
      this.withStepTemplate(instance.getStepTemplate());
      this.withSteps(instance.getSteps());
      this.withVolumes(instance.getVolumes());
      this.withWorkspaces(instance.getWorkspaces());
    }
  }
  private String description;
  private String displayName;
  private ArrayList<ParamSpecBuilder> params = new ArrayList<ParamSpecBuilder>();
  private ArrayList<TaskResultBuilder> results = new ArrayList<TaskResultBuilder>();
  private ArrayList<SidecarBuilder> sidecars = new ArrayList<SidecarBuilder>();
  private StepTemplateBuilder stepTemplate;
  private ArrayList<StepBuilder> steps = new ArrayList<StepBuilder>();
  private ArrayList<VolumeBuilder> volumes = new ArrayList<VolumeBuilder>();
  private ArrayList<WorkspaceDeclarationBuilder> workspaces = new ArrayList<WorkspaceDeclarationBuilder>();
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public String getDisplayName() {
    return this.displayName;
  }
  public A withDisplayName(String displayName) {
    this.displayName=displayName; return (A) this;
  }
  public Boolean hasDisplayName() {
    return this.displayName != null;
  }
  public A addToParams(int index,ParamSpec item) {
    if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
    ParamSpecBuilder builder = new ParamSpecBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").add(index, builder); params.add(index, builder);}
    return (A)this;
  }
  public A setToParams(int index,ParamSpec item) {
    if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
    ParamSpecBuilder builder = new ParamSpecBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").set(index, builder); params.set(index, builder);}
    return (A)this;
  }
  public A addToParams(io.fabric8.tekton.pipeline.v1.ParamSpec... items) {
    if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
    for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  public A addAllToParams(Collection<ParamSpec> items) {
    if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
    for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  public A removeFromParams(io.fabric8.tekton.pipeline.v1.ParamSpec... items) {
    for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
  }
  public A removeAllFromParams(Collection<ParamSpec> items) {
    for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromParams(Predicate<ParamSpecBuilder> predicate) {
    if (params == null) return (A) this;
    final Iterator<ParamSpecBuilder> each = params.iterator();
    final List visitables = _visitables.get("params");
    while (each.hasNext()) {
      ParamSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildParams instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ParamSpec> getParams() {
    return params != null ? build(params) : null;
  }
  public List<ParamSpec> buildParams() {
    return params != null ? build(params) : null;
  }
  public ParamSpec buildParam(int index) {
    return this.params.get(index).build();
  }
  public ParamSpec buildFirstParam() {
    return this.params.get(0).build();
  }
  public ParamSpec buildLastParam() {
    return this.params.get(params.size() - 1).build();
  }
  public ParamSpec buildMatchingParam(Predicate<ParamSpecBuilder> predicate) {
    for (ParamSpecBuilder item: params) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingParam(Predicate<ParamSpecBuilder> predicate) {
    for (ParamSpecBuilder item: params) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParams(List<ParamSpec> params) {
    if (this.params != null) { _visitables.get("params").clear();}
    if (params != null) {this.params = new ArrayList(); for (ParamSpec item : params){this.addToParams(item);}} else { this.params = null;} return (A) this;
  }
  public A withParams(io.fabric8.tekton.pipeline.v1.ParamSpec... params) {
    if (this.params != null) {this.params.clear(); _visitables.remove("params"); }
    if (params != null) {for (ParamSpec item :params){ this.addToParams(item);}} return (A) this;
  }
  public Boolean hasParams() {
    return params != null && !params.isEmpty();
  }
  public TaskSpecFluentImpl.ParamsNested<A> addNewParam() {
    return new TaskSpecFluentImpl.ParamsNestedImpl();
  }
  public TaskSpecFluentImpl.ParamsNested<A> addNewParamLike(ParamSpec item) {
    return new TaskSpecFluentImpl.ParamsNestedImpl(-1, item);
  }
  public TaskSpecFluentImpl.ParamsNested<A> setNewParamLike(int index,ParamSpec item) {
    return new TaskSpecFluentImpl.ParamsNestedImpl(index, item);
  }
  public TaskSpecFluentImpl.ParamsNested<A> editParam(int index) {
    if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
    return setNewParamLike(index, buildParam(index));
  }
  public TaskSpecFluentImpl.ParamsNested<A> editFirstParam() {
    if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
    return setNewParamLike(0, buildParam(0));
  }
  public TaskSpecFluentImpl.ParamsNested<A> editLastParam() {
    int index = params.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
    return setNewParamLike(index, buildParam(index));
  }
  public TaskSpecFluentImpl.ParamsNested<A> editMatchingParam(Predicate<ParamSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<params.size();i++) { 
    if (predicate.test(params.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
    return setNewParamLike(index, buildParam(index));
  }
  public A addToResults(int index,TaskResult item) {
    if (this.results == null) {this.results = new ArrayList<TaskResultBuilder>();}
    TaskResultBuilder builder = new TaskResultBuilder(item);
    if (index < 0 || index >= results.size()) { _visitables.get("results").add(builder); results.add(builder); } else { _visitables.get("results").add(index, builder); results.add(index, builder);}
    return (A)this;
  }
  public A setToResults(int index,TaskResult item) {
    if (this.results == null) {this.results = new ArrayList<TaskResultBuilder>();}
    TaskResultBuilder builder = new TaskResultBuilder(item);
    if (index < 0 || index >= results.size()) { _visitables.get("results").add(builder); results.add(builder); } else { _visitables.get("results").set(index, builder); results.set(index, builder);}
    return (A)this;
  }
  public A addToResults(io.fabric8.tekton.pipeline.v1.TaskResult... items) {
    if (this.results == null) {this.results = new ArrayList<TaskResultBuilder>();}
    for (TaskResult item : items) {TaskResultBuilder builder = new TaskResultBuilder(item);_visitables.get("results").add(builder);this.results.add(builder);} return (A)this;
  }
  public A addAllToResults(Collection<TaskResult> items) {
    if (this.results == null) {this.results = new ArrayList<TaskResultBuilder>();}
    for (TaskResult item : items) {TaskResultBuilder builder = new TaskResultBuilder(item);_visitables.get("results").add(builder);this.results.add(builder);} return (A)this;
  }
  public A removeFromResults(io.fabric8.tekton.pipeline.v1.TaskResult... items) {
    for (TaskResult item : items) {TaskResultBuilder builder = new TaskResultBuilder(item);_visitables.get("results").remove(builder);if (this.results != null) {this.results.remove(builder);}} return (A)this;
  }
  public A removeAllFromResults(Collection<TaskResult> items) {
    for (TaskResult item : items) {TaskResultBuilder builder = new TaskResultBuilder(item);_visitables.get("results").remove(builder);if (this.results != null) {this.results.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResults(Predicate<TaskResultBuilder> predicate) {
    if (results == null) return (A) this;
    final Iterator<TaskResultBuilder> each = results.iterator();
    final List visitables = _visitables.get("results");
    while (each.hasNext()) {
      TaskResultBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResults instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TaskResult> getResults() {
    return results != null ? build(results) : null;
  }
  public List<TaskResult> buildResults() {
    return results != null ? build(results) : null;
  }
  public TaskResult buildResult(int index) {
    return this.results.get(index).build();
  }
  public TaskResult buildFirstResult() {
    return this.results.get(0).build();
  }
  public TaskResult buildLastResult() {
    return this.results.get(results.size() - 1).build();
  }
  public TaskResult buildMatchingResult(Predicate<TaskResultBuilder> predicate) {
    for (TaskResultBuilder item: results) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResult(Predicate<TaskResultBuilder> predicate) {
    for (TaskResultBuilder item: results) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResults(List<TaskResult> results) {
    if (this.results != null) { _visitables.get("results").clear();}
    if (results != null) {this.results = new ArrayList(); for (TaskResult item : results){this.addToResults(item);}} else { this.results = null;} return (A) this;
  }
  public A withResults(io.fabric8.tekton.pipeline.v1.TaskResult... results) {
    if (this.results != null) {this.results.clear(); _visitables.remove("results"); }
    if (results != null) {for (TaskResult item :results){ this.addToResults(item);}} return (A) this;
  }
  public Boolean hasResults() {
    return results != null && !results.isEmpty();
  }
  public TaskSpecFluentImpl.ResultsNested<A> addNewResult() {
    return new TaskSpecFluentImpl.ResultsNestedImpl();
  }
  public TaskSpecFluentImpl.ResultsNested<A> addNewResultLike(TaskResult item) {
    return new TaskSpecFluentImpl.ResultsNestedImpl(-1, item);
  }
  public TaskSpecFluentImpl.ResultsNested<A> setNewResultLike(int index,TaskResult item) {
    return new TaskSpecFluentImpl.ResultsNestedImpl(index, item);
  }
  public TaskSpecFluentImpl.ResultsNested<A> editResult(int index) {
    if (results.size() <= index) throw new RuntimeException("Can't edit results. Index exceeds size.");
    return setNewResultLike(index, buildResult(index));
  }
  public TaskSpecFluentImpl.ResultsNested<A> editFirstResult() {
    if (results.size() == 0) throw new RuntimeException("Can't edit first results. The list is empty.");
    return setNewResultLike(0, buildResult(0));
  }
  public TaskSpecFluentImpl.ResultsNested<A> editLastResult() {
    int index = results.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last results. The list is empty.");
    return setNewResultLike(index, buildResult(index));
  }
  public TaskSpecFluentImpl.ResultsNested<A> editMatchingResult(Predicate<TaskResultBuilder> predicate) {
    int index = -1;
    for (int i=0;i<results.size();i++) { 
    if (predicate.test(results.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching results. No match found.");
    return setNewResultLike(index, buildResult(index));
  }
  public A addToSidecars(int index,Sidecar item) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarBuilder>();}
    SidecarBuilder builder = new SidecarBuilder(item);
    if (index < 0 || index >= sidecars.size()) { _visitables.get("sidecars").add(builder); sidecars.add(builder); } else { _visitables.get("sidecars").add(index, builder); sidecars.add(index, builder);}
    return (A)this;
  }
  public A setToSidecars(int index,Sidecar item) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarBuilder>();}
    SidecarBuilder builder = new SidecarBuilder(item);
    if (index < 0 || index >= sidecars.size()) { _visitables.get("sidecars").add(builder); sidecars.add(builder); } else { _visitables.get("sidecars").set(index, builder); sidecars.set(index, builder);}
    return (A)this;
  }
  public A addToSidecars(io.fabric8.tekton.pipeline.v1.Sidecar... items) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarBuilder>();}
    for (Sidecar item : items) {SidecarBuilder builder = new SidecarBuilder(item);_visitables.get("sidecars").add(builder);this.sidecars.add(builder);} return (A)this;
  }
  public A addAllToSidecars(Collection<Sidecar> items) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarBuilder>();}
    for (Sidecar item : items) {SidecarBuilder builder = new SidecarBuilder(item);_visitables.get("sidecars").add(builder);this.sidecars.add(builder);} return (A)this;
  }
  public A removeFromSidecars(io.fabric8.tekton.pipeline.v1.Sidecar... items) {
    for (Sidecar item : items) {SidecarBuilder builder = new SidecarBuilder(item);_visitables.get("sidecars").remove(builder);if (this.sidecars != null) {this.sidecars.remove(builder);}} return (A)this;
  }
  public A removeAllFromSidecars(Collection<Sidecar> items) {
    for (Sidecar item : items) {SidecarBuilder builder = new SidecarBuilder(item);_visitables.get("sidecars").remove(builder);if (this.sidecars != null) {this.sidecars.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSidecars(Predicate<SidecarBuilder> predicate) {
    if (sidecars == null) return (A) this;
    final Iterator<SidecarBuilder> each = sidecars.iterator();
    final List visitables = _visitables.get("sidecars");
    while (each.hasNext()) {
      SidecarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSidecars instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Sidecar> getSidecars() {
    return sidecars != null ? build(sidecars) : null;
  }
  public List<Sidecar> buildSidecars() {
    return sidecars != null ? build(sidecars) : null;
  }
  public Sidecar buildSidecar(int index) {
    return this.sidecars.get(index).build();
  }
  public Sidecar buildFirstSidecar() {
    return this.sidecars.get(0).build();
  }
  public Sidecar buildLastSidecar() {
    return this.sidecars.get(sidecars.size() - 1).build();
  }
  public Sidecar buildMatchingSidecar(Predicate<SidecarBuilder> predicate) {
    for (SidecarBuilder item: sidecars) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSidecar(Predicate<SidecarBuilder> predicate) {
    for (SidecarBuilder item: sidecars) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSidecars(List<Sidecar> sidecars) {
    if (this.sidecars != null) { _visitables.get("sidecars").clear();}
    if (sidecars != null) {this.sidecars = new ArrayList(); for (Sidecar item : sidecars){this.addToSidecars(item);}} else { this.sidecars = null;} return (A) this;
  }
  public A withSidecars(io.fabric8.tekton.pipeline.v1.Sidecar... sidecars) {
    if (this.sidecars != null) {this.sidecars.clear(); _visitables.remove("sidecars"); }
    if (sidecars != null) {for (Sidecar item :sidecars){ this.addToSidecars(item);}} return (A) this;
  }
  public Boolean hasSidecars() {
    return sidecars != null && !sidecars.isEmpty();
  }
  public TaskSpecFluentImpl.SidecarsNested<A> addNewSidecar() {
    return new TaskSpecFluentImpl.SidecarsNestedImpl();
  }
  public TaskSpecFluentImpl.SidecarsNested<A> addNewSidecarLike(Sidecar item) {
    return new TaskSpecFluentImpl.SidecarsNestedImpl(-1, item);
  }
  public TaskSpecFluentImpl.SidecarsNested<A> setNewSidecarLike(int index,Sidecar item) {
    return new TaskSpecFluentImpl.SidecarsNestedImpl(index, item);
  }
  public TaskSpecFluentImpl.SidecarsNested<A> editSidecar(int index) {
    if (sidecars.size() <= index) throw new RuntimeException("Can't edit sidecars. Index exceeds size.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  public TaskSpecFluentImpl.SidecarsNested<A> editFirstSidecar() {
    if (sidecars.size() == 0) throw new RuntimeException("Can't edit first sidecars. The list is empty.");
    return setNewSidecarLike(0, buildSidecar(0));
  }
  public TaskSpecFluentImpl.SidecarsNested<A> editLastSidecar() {
    int index = sidecars.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sidecars. The list is empty.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  public TaskSpecFluentImpl.SidecarsNested<A> editMatchingSidecar(Predicate<SidecarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sidecars.size();i++) { 
    if (predicate.test(sidecars.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sidecars. No match found.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  
  /**
   * This method has been deprecated, please use method buildStepTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public StepTemplate getStepTemplate() {
    return this.stepTemplate!=null ?this.stepTemplate.build():null;
  }
  public StepTemplate buildStepTemplate() {
    return this.stepTemplate!=null ?this.stepTemplate.build():null;
  }
  public A withStepTemplate(StepTemplate stepTemplate) {
    _visitables.get("stepTemplate").remove(this.stepTemplate);
    if (stepTemplate!=null){ this.stepTemplate= new StepTemplateBuilder(stepTemplate); _visitables.get("stepTemplate").add(this.stepTemplate);} else { this.stepTemplate = null; _visitables.get("stepTemplate").remove(this.stepTemplate); } return (A) this;
  }
  public Boolean hasStepTemplate() {
    return this.stepTemplate != null;
  }
  public TaskSpecFluentImpl.StepTemplateNested<A> withNewStepTemplate() {
    return new TaskSpecFluentImpl.StepTemplateNestedImpl();
  }
  public TaskSpecFluentImpl.StepTemplateNested<A> withNewStepTemplateLike(StepTemplate item) {
    return new TaskSpecFluentImpl.StepTemplateNestedImpl(item);
  }
  public TaskSpecFluentImpl.StepTemplateNested<A> editStepTemplate() {
    return withNewStepTemplateLike(getStepTemplate());
  }
  public TaskSpecFluentImpl.StepTemplateNested<A> editOrNewStepTemplate() {
    return withNewStepTemplateLike(getStepTemplate() != null ? getStepTemplate(): new StepTemplateBuilder().build());
  }
  public TaskSpecFluentImpl.StepTemplateNested<A> editOrNewStepTemplateLike(StepTemplate item) {
    return withNewStepTemplateLike(getStepTemplate() != null ? getStepTemplate(): item);
  }
  public A addToSteps(int index,Step item) {
    if (this.steps == null) {this.steps = new ArrayList<StepBuilder>();}
    StepBuilder builder = new StepBuilder(item);
    if (index < 0 || index >= steps.size()) { _visitables.get("steps").add(builder); steps.add(builder); } else { _visitables.get("steps").add(index, builder); steps.add(index, builder);}
    return (A)this;
  }
  public A setToSteps(int index,Step item) {
    if (this.steps == null) {this.steps = new ArrayList<StepBuilder>();}
    StepBuilder builder = new StepBuilder(item);
    if (index < 0 || index >= steps.size()) { _visitables.get("steps").add(builder); steps.add(builder); } else { _visitables.get("steps").set(index, builder); steps.set(index, builder);}
    return (A)this;
  }
  public A addToSteps(io.fabric8.tekton.pipeline.v1.Step... items) {
    if (this.steps == null) {this.steps = new ArrayList<StepBuilder>();}
    for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
  }
  public A addAllToSteps(Collection<Step> items) {
    if (this.steps == null) {this.steps = new ArrayList<StepBuilder>();}
    for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
  }
  public A removeFromSteps(io.fabric8.tekton.pipeline.v1.Step... items) {
    for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
  }
  public A removeAllFromSteps(Collection<Step> items) {
    for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSteps(Predicate<StepBuilder> predicate) {
    if (steps == null) return (A) this;
    final Iterator<StepBuilder> each = steps.iterator();
    final List visitables = _visitables.get("steps");
    while (each.hasNext()) {
      StepBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSteps instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Step> getSteps() {
    return steps != null ? build(steps) : null;
  }
  public List<Step> buildSteps() {
    return steps != null ? build(steps) : null;
  }
  public Step buildStep(int index) {
    return this.steps.get(index).build();
  }
  public Step buildFirstStep() {
    return this.steps.get(0).build();
  }
  public Step buildLastStep() {
    return this.steps.get(steps.size() - 1).build();
  }
  public Step buildMatchingStep(Predicate<StepBuilder> predicate) {
    for (StepBuilder item: steps) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingStep(Predicate<StepBuilder> predicate) {
    for (StepBuilder item: steps) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSteps(List<Step> steps) {
    if (this.steps != null) { _visitables.get("steps").clear();}
    if (steps != null) {this.steps = new ArrayList(); for (Step item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
  }
  public A withSteps(io.fabric8.tekton.pipeline.v1.Step... steps) {
    if (this.steps != null) {this.steps.clear(); _visitables.remove("steps"); }
    if (steps != null) {for (Step item :steps){ this.addToSteps(item);}} return (A) this;
  }
  public Boolean hasSteps() {
    return steps != null && !steps.isEmpty();
  }
  public TaskSpecFluentImpl.StepsNested<A> addNewStep() {
    return new TaskSpecFluentImpl.StepsNestedImpl();
  }
  public TaskSpecFluentImpl.StepsNested<A> addNewStepLike(Step item) {
    return new TaskSpecFluentImpl.StepsNestedImpl(-1, item);
  }
  public TaskSpecFluentImpl.StepsNested<A> setNewStepLike(int index,Step item) {
    return new TaskSpecFluentImpl.StepsNestedImpl(index, item);
  }
  public TaskSpecFluentImpl.StepsNested<A> editStep(int index) {
    if (steps.size() <= index) throw new RuntimeException("Can't edit steps. Index exceeds size.");
    return setNewStepLike(index, buildStep(index));
  }
  public TaskSpecFluentImpl.StepsNested<A> editFirstStep() {
    if (steps.size() == 0) throw new RuntimeException("Can't edit first steps. The list is empty.");
    return setNewStepLike(0, buildStep(0));
  }
  public TaskSpecFluentImpl.StepsNested<A> editLastStep() {
    int index = steps.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last steps. The list is empty.");
    return setNewStepLike(index, buildStep(index));
  }
  public TaskSpecFluentImpl.StepsNested<A> editMatchingStep(Predicate<StepBuilder> predicate) {
    int index = -1;
    for (int i=0;i<steps.size();i++) { 
    if (predicate.test(steps.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching steps. No match found.");
    return setNewStepLike(index, buildStep(index));
  }
  public A addToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").add(index, builder); volumes.add(index, builder);}
    return (A)this;
  }
  public A setToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);
    if (index < 0 || index >= volumes.size()) { _visitables.get("volumes").add(builder); volumes.add(builder); } else { _visitables.get("volumes").set(index, builder); volumes.set(index, builder);}
    return (A)this;
  }
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A addAllToVolumes(Collection<Volume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumes(Collection<Volume> items) {
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<VolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      VolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Volume> getVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public List<Volume> buildVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public Volume buildVolume(int index) {
    return this.volumes.get(index).build();
  }
  public Volume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  public Volume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
    for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
    for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<Volume> volumes) {
    if (this.volumes != null) { _visitables.get("volumes").clear();}
    if (volumes != null) {this.volumes = new ArrayList(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {this.volumes.clear(); _visitables.remove("volumes"); }
    if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public TaskSpecFluentImpl.VolumesNested<A> addNewVolume() {
    return new TaskSpecFluentImpl.VolumesNestedImpl();
  }
  public TaskSpecFluentImpl.VolumesNested<A> addNewVolumeLike(Volume item) {
    return new TaskSpecFluentImpl.VolumesNestedImpl(-1, item);
  }
  public TaskSpecFluentImpl.VolumesNested<A> setNewVolumeLike(int index,Volume item) {
    return new TaskSpecFluentImpl.VolumesNestedImpl(index, item);
  }
  public TaskSpecFluentImpl.VolumesNested<A> editVolume(int index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public TaskSpecFluentImpl.VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  public TaskSpecFluentImpl.VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public TaskSpecFluentImpl.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public A addToWorkspaces(int index,WorkspaceDeclaration item) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceDeclarationBuilder>();}
    WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
    if (index < 0 || index >= workspaces.size()) { _visitables.get("workspaces").add(builder); workspaces.add(builder); } else { _visitables.get("workspaces").add(index, builder); workspaces.add(index, builder);}
    return (A)this;
  }
  public A setToWorkspaces(int index,WorkspaceDeclaration item) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceDeclarationBuilder>();}
    WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);
    if (index < 0 || index >= workspaces.size()) { _visitables.get("workspaces").add(builder); workspaces.add(builder); } else { _visitables.get("workspaces").set(index, builder); workspaces.set(index, builder);}
    return (A)this;
  }
  public A addToWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspaceDeclaration... items) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceDeclarationBuilder>();}
    for (WorkspaceDeclaration item : items) {WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);_visitables.get("workspaces").add(builder);this.workspaces.add(builder);} return (A)this;
  }
  public A addAllToWorkspaces(Collection<WorkspaceDeclaration> items) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceDeclarationBuilder>();}
    for (WorkspaceDeclaration item : items) {WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);_visitables.get("workspaces").add(builder);this.workspaces.add(builder);} return (A)this;
  }
  public A removeFromWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspaceDeclaration... items) {
    for (WorkspaceDeclaration item : items) {WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);_visitables.get("workspaces").remove(builder);if (this.workspaces != null) {this.workspaces.remove(builder);}} return (A)this;
  }
  public A removeAllFromWorkspaces(Collection<WorkspaceDeclaration> items) {
    for (WorkspaceDeclaration item : items) {WorkspaceDeclarationBuilder builder = new WorkspaceDeclarationBuilder(item);_visitables.get("workspaces").remove(builder);if (this.workspaces != null) {this.workspaces.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromWorkspaces(Predicate<WorkspaceDeclarationBuilder> predicate) {
    if (workspaces == null) return (A) this;
    final Iterator<WorkspaceDeclarationBuilder> each = workspaces.iterator();
    final List visitables = _visitables.get("workspaces");
    while (each.hasNext()) {
      WorkspaceDeclarationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildWorkspaces instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<WorkspaceDeclaration> getWorkspaces() {
    return workspaces != null ? build(workspaces) : null;
  }
  public List<WorkspaceDeclaration> buildWorkspaces() {
    return workspaces != null ? build(workspaces) : null;
  }
  public WorkspaceDeclaration buildWorkspace(int index) {
    return this.workspaces.get(index).build();
  }
  public WorkspaceDeclaration buildFirstWorkspace() {
    return this.workspaces.get(0).build();
  }
  public WorkspaceDeclaration buildLastWorkspace() {
    return this.workspaces.get(workspaces.size() - 1).build();
  }
  public WorkspaceDeclaration buildMatchingWorkspace(Predicate<WorkspaceDeclarationBuilder> predicate) {
    for (WorkspaceDeclarationBuilder item: workspaces) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingWorkspace(Predicate<WorkspaceDeclarationBuilder> predicate) {
    for (WorkspaceDeclarationBuilder item: workspaces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withWorkspaces(List<WorkspaceDeclaration> workspaces) {
    if (this.workspaces != null) { _visitables.get("workspaces").clear();}
    if (workspaces != null) {this.workspaces = new ArrayList(); for (WorkspaceDeclaration item : workspaces){this.addToWorkspaces(item);}} else { this.workspaces = null;} return (A) this;
  }
  public A withWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspaceDeclaration... workspaces) {
    if (this.workspaces != null) {this.workspaces.clear(); _visitables.remove("workspaces"); }
    if (workspaces != null) {for (WorkspaceDeclaration item :workspaces){ this.addToWorkspaces(item);}} return (A) this;
  }
  public Boolean hasWorkspaces() {
    return workspaces != null && !workspaces.isEmpty();
  }
  public A addNewWorkspace(String description,String mountPath,String name,Boolean optional,Boolean readOnly) {
    return (A)addToWorkspaces(new WorkspaceDeclaration(description, mountPath, name, optional, readOnly));
  }
  public TaskSpecFluentImpl.WorkspacesNested<A> addNewWorkspace() {
    return new TaskSpecFluentImpl.WorkspacesNestedImpl();
  }
  public TaskSpecFluentImpl.WorkspacesNested<A> addNewWorkspaceLike(WorkspaceDeclaration item) {
    return new TaskSpecFluentImpl.WorkspacesNestedImpl(-1, item);
  }
  public TaskSpecFluentImpl.WorkspacesNested<A> setNewWorkspaceLike(int index,WorkspaceDeclaration item) {
    return new TaskSpecFluentImpl.WorkspacesNestedImpl(index, item);
  }
  public TaskSpecFluentImpl.WorkspacesNested<A> editWorkspace(int index) {
    if (workspaces.size() <= index) throw new RuntimeException("Can't edit workspaces. Index exceeds size.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  public TaskSpecFluentImpl.WorkspacesNested<A> editFirstWorkspace() {
    if (workspaces.size() == 0) throw new RuntimeException("Can't edit first workspaces. The list is empty.");
    return setNewWorkspaceLike(0, buildWorkspace(0));
  }
  public TaskSpecFluentImpl.WorkspacesNested<A> editLastWorkspace() {
    int index = workspaces.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last workspaces. The list is empty.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  public TaskSpecFluentImpl.WorkspacesNested<A> editMatchingWorkspace(Predicate<WorkspaceDeclarationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<workspaces.size();i++) { 
    if (predicate.test(workspaces.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching workspaces. No match found.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TaskSpecFluentImpl that = (TaskSpecFluentImpl) o;
    if (!java.util.Objects.equals(description, that.description)) return false;

    if (!java.util.Objects.equals(displayName, that.displayName)) return false;

    if (!java.util.Objects.equals(params, that.params)) return false;

    if (!java.util.Objects.equals(results, that.results)) return false;

    if (!java.util.Objects.equals(sidecars, that.sidecars)) return false;

    if (!java.util.Objects.equals(stepTemplate, that.stepTemplate)) return false;

    if (!java.util.Objects.equals(steps, that.steps)) return false;

    if (!java.util.Objects.equals(volumes, that.volumes)) return false;

    if (!java.util.Objects.equals(workspaces, that.workspaces)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(description,  displayName,  params,  results,  sidecars,  stepTemplate,  steps,  volumes,  workspaces,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (displayName != null) { sb.append("displayName:"); sb.append(displayName + ","); }
    if (params != null) { sb.append("params:"); sb.append(params + ","); }
    if (results != null) { sb.append("results:"); sb.append(results + ","); }
    if (sidecars != null) { sb.append("sidecars:"); sb.append(sidecars + ","); }
    if (stepTemplate != null) { sb.append("stepTemplate:"); sb.append(stepTemplate + ","); }
    if (steps != null) { sb.append("steps:"); sb.append(steps + ","); }
    if (volumes != null) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (workspaces != null) { sb.append("workspaces:"); sb.append(workspaces); }
    sb.append("}");
    return sb.toString();
  }
  class ParamsNestedImpl<N> extends ParamSpecFluentImpl<TaskSpecFluentImpl.ParamsNested<N>> implements TaskSpecFluentImpl.ParamsNested<N>,Nested<N>{
    ParamsNestedImpl(int index,ParamSpec item) {
      this.index = index;
      this.builder = new ParamSpecBuilder(this, item);
    }
    ParamsNestedImpl() {
      this.index = -1;
      this.builder = new ParamSpecBuilder(this);
    }
    ParamSpecBuilder builder;
    int index;
    public N and() {
      return (N) TaskSpecFluentImpl.this.setToParams(index,builder.build());
    }
    public N endParam() {
      return and();
    }
    
  }
  class ResultsNestedImpl<N> extends TaskResultFluentImpl<TaskSpecFluentImpl.ResultsNested<N>> implements TaskSpecFluentImpl.ResultsNested<N>,Nested<N>{
    ResultsNestedImpl(int index,TaskResult item) {
      this.index = index;
      this.builder = new TaskResultBuilder(this, item);
    }
    ResultsNestedImpl() {
      this.index = -1;
      this.builder = new TaskResultBuilder(this);
    }
    TaskResultBuilder builder;
    int index;
    public N and() {
      return (N) TaskSpecFluentImpl.this.setToResults(index,builder.build());
    }
    public N endResult() {
      return and();
    }
    
  }
  class SidecarsNestedImpl<N> extends SidecarFluentImpl<TaskSpecFluentImpl.SidecarsNested<N>> implements TaskSpecFluentImpl.SidecarsNested<N>,Nested<N>{
    SidecarsNestedImpl(int index,Sidecar item) {
      this.index = index;
      this.builder = new SidecarBuilder(this, item);
    }
    SidecarsNestedImpl() {
      this.index = -1;
      this.builder = new SidecarBuilder(this);
    }
    SidecarBuilder builder;
    int index;
    public N and() {
      return (N) TaskSpecFluentImpl.this.setToSidecars(index,builder.build());
    }
    public N endSidecar() {
      return and();
    }
    
  }
  class StepTemplateNestedImpl<N> extends StepTemplateFluentImpl<TaskSpecFluentImpl.StepTemplateNested<N>> implements TaskSpecFluentImpl.StepTemplateNested<N>,Nested<N>{
    StepTemplateNestedImpl(StepTemplate item) {
      this.builder = new StepTemplateBuilder(this, item);
    }
    StepTemplateNestedImpl() {
      this.builder = new StepTemplateBuilder(this);
    }
    StepTemplateBuilder builder;
    public N and() {
      return (N) TaskSpecFluentImpl.this.withStepTemplate(builder.build());
    }
    public N endStepTemplate() {
      return and();
    }
    
  }
  class StepsNestedImpl<N> extends StepFluentImpl<TaskSpecFluentImpl.StepsNested<N>> implements TaskSpecFluentImpl.StepsNested<N>,Nested<N>{
    StepsNestedImpl(int index,Step item) {
      this.index = index;
      this.builder = new StepBuilder(this, item);
    }
    StepsNestedImpl() {
      this.index = -1;
      this.builder = new StepBuilder(this);
    }
    StepBuilder builder;
    int index;
    public N and() {
      return (N) TaskSpecFluentImpl.this.setToSteps(index,builder.build());
    }
    public N endStep() {
      return and();
    }
    
  }
  class VolumesNestedImpl<N> extends VolumeFluentImpl<TaskSpecFluentImpl.VolumesNested<N>> implements TaskSpecFluentImpl.VolumesNested<N>,Nested<N>{
    VolumesNestedImpl(int index,Volume item) {
      this.index = index;
      this.builder = new VolumeBuilder(this, item);
    }
    VolumesNestedImpl() {
      this.index = -1;
      this.builder = new VolumeBuilder(this);
    }
    VolumeBuilder builder;
    int index;
    public N and() {
      return (N) TaskSpecFluentImpl.this.setToVolumes(index,builder.build());
    }
    public N endVolume() {
      return and();
    }
    
  }
  class WorkspacesNestedImpl<N> extends WorkspaceDeclarationFluentImpl<TaskSpecFluentImpl.WorkspacesNested<N>> implements TaskSpecFluentImpl.WorkspacesNested<N>,Nested<N>{
    WorkspacesNestedImpl(int index,WorkspaceDeclaration item) {
      this.index = index;
      this.builder = new WorkspaceDeclarationBuilder(this, item);
    }
    WorkspacesNestedImpl() {
      this.index = -1;
      this.builder = new WorkspaceDeclarationBuilder(this);
    }
    WorkspaceDeclarationBuilder builder;
    int index;
    public N and() {
      return (N) TaskSpecFluentImpl.this.setToWorkspaces(index,builder.build());
    }
    public N endWorkspace() {
      return and();
    }
    
  }
  
}