package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskSpecBuilder extends TaskSpecFluentImpl<TaskSpecBuilder> implements VisitableBuilder<TaskSpec,TaskSpecBuilder>{
  public TaskSpecBuilder() {
    this(false);
  }
  public TaskSpecBuilder(Boolean validationEnabled) {
    this(new TaskSpec(), validationEnabled);
  }
  public TaskSpecBuilder(TaskSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskSpecBuilder(TaskSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TaskSpec(), validationEnabled);
  }
  public TaskSpecBuilder(TaskSpecFluent<?> fluent,TaskSpec instance) {
    this(fluent, instance, false);
  }
  public TaskSpecBuilder(TaskSpecFluent<?> fluent,TaskSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withParams(instance.getParams());
      fluent.withResults(instance.getResults());
      fluent.withSidecars(instance.getSidecars());
      fluent.withStepTemplate(instance.getStepTemplate());
      fluent.withSteps(instance.getSteps());
      fluent.withVolumes(instance.getVolumes());
      fluent.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaskSpecBuilder(TaskSpec instance) {
    this(instance,false);
  }
  public TaskSpecBuilder(TaskSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withParams(instance.getParams());
      this.withResults(instance.getResults());
      this.withSidecars(instance.getSidecars());
      this.withStepTemplate(instance.getStepTemplate());
      this.withSteps(instance.getSteps());
      this.withVolumes(instance.getVolumes());
      this.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaskSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TaskSpec build() {
    TaskSpec buildable = new TaskSpec(fluent.getDescription(),fluent.getDisplayName(),fluent.getParams(),fluent.getResults(),fluent.getSidecars(),fluent.getStepTemplate(),fluent.getSteps(),fluent.getVolumes(),fluent.getWorkspaces());
    return buildable;
  }
  
}