package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskRunStepSpecBuilder extends TaskRunStepSpecFluentImpl<TaskRunStepSpecBuilder> implements VisitableBuilder<TaskRunStepSpec,TaskRunStepSpecBuilder>{
  public TaskRunStepSpecBuilder() {
    this(false);
  }
  public TaskRunStepSpecBuilder(Boolean validationEnabled) {
    this(new TaskRunStepSpec(), validationEnabled);
  }
  public TaskRunStepSpecBuilder(TaskRunStepSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskRunStepSpecBuilder(TaskRunStepSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TaskRunStepSpec(), validationEnabled);
  }
  public TaskRunStepSpecBuilder(TaskRunStepSpecFluent<?> fluent,TaskRunStepSpec instance) {
    this(fluent, instance, false);
  }
  public TaskRunStepSpecBuilder(TaskRunStepSpecFluent<?> fluent,TaskRunStepSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withComputeResources(instance.getComputeResources());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaskRunStepSpecBuilder(TaskRunStepSpec instance) {
    this(instance,false);
  }
  public TaskRunStepSpecBuilder(TaskRunStepSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withComputeResources(instance.getComputeResources());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaskRunStepSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TaskRunStepSpec build() {
    TaskRunStepSpec buildable = new TaskRunStepSpec(fluent.getComputeResources(),fluent.getName());
    return buildable;
  }
  
}