package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TaskRunStatusFluentImpl<A extends TaskRunStatusFluent<A>> extends BaseFluent<A> implements TaskRunStatusFluent<A>{
  public TaskRunStatusFluentImpl() {
  }
  public TaskRunStatusFluentImpl(TaskRunStatus instance) {
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCompletionTime(instance.getCompletionTime());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withPodName(instance.getPodName());
      this.withProvenance(instance.getProvenance());
      this.withResults(instance.getResults());
      this.withRetriesStatus(instance.getRetriesStatus());
      this.withSidecars(instance.getSidecars());
      this.withSpanContext(instance.getSpanContext());
      this.withStartTime(instance.getStartTime());
      this.withSteps(instance.getSteps());
      this.withTaskSpec(instance.getTaskSpec());
    }
  }
  private Map<String,String> annotations;
  private String completionTime;
  private List<Condition> conditions = new ArrayList<Condition>();
  private Long observedGeneration;
  private String podName;
  private ProvenanceBuilder provenance;
  private ArrayList<TaskRunResultBuilder> results = new ArrayList<TaskRunResultBuilder>();
  private ArrayList<TaskRunStatusBuilder> retriesStatus = new ArrayList<TaskRunStatusBuilder>();
  private ArrayList<SidecarStateBuilder> sidecars = new ArrayList<SidecarStateBuilder>();
  private Map<String,String> spanContext;
  private String startTime;
  private ArrayList<StepStateBuilder> steps = new ArrayList<StepStateBuilder>();
  private TaskSpecBuilder taskSpec;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public String getCompletionTime() {
    return this.completionTime;
  }
  public A withCompletionTime(String completionTime) {
    this.completionTime=completionTime; return (A) this;
  }
  public Boolean hasCompletionTime() {
    return this.completionTime != null;
  }
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.knative.internal.pkg.apis.Condition... items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public List<Condition> getConditions() {
    return this.conditions;
  }
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.knative.internal.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public String getPodName() {
    return this.podName;
  }
  public A withPodName(String podName) {
    this.podName=podName; return (A) this;
  }
  public Boolean hasPodName() {
    return this.podName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildProvenance instead.
   * @return The buildable object.
   */
  @Deprecated
  public Provenance getProvenance() {
    return this.provenance!=null ?this.provenance.build():null;
  }
  public Provenance buildProvenance() {
    return this.provenance!=null ?this.provenance.build():null;
  }
  public A withProvenance(Provenance provenance) {
    _visitables.get("provenance").remove(this.provenance);
    if (provenance!=null){ this.provenance= new ProvenanceBuilder(provenance); _visitables.get("provenance").add(this.provenance);} else { this.provenance = null; _visitables.get("provenance").remove(this.provenance); } return (A) this;
  }
  public Boolean hasProvenance() {
    return this.provenance != null;
  }
  public TaskRunStatusFluentImpl.ProvenanceNested<A> withNewProvenance() {
    return new TaskRunStatusFluentImpl.ProvenanceNestedImpl();
  }
  public TaskRunStatusFluentImpl.ProvenanceNested<A> withNewProvenanceLike(Provenance item) {
    return new TaskRunStatusFluentImpl.ProvenanceNestedImpl(item);
  }
  public TaskRunStatusFluentImpl.ProvenanceNested<A> editProvenance() {
    return withNewProvenanceLike(getProvenance());
  }
  public TaskRunStatusFluentImpl.ProvenanceNested<A> editOrNewProvenance() {
    return withNewProvenanceLike(getProvenance() != null ? getProvenance(): new ProvenanceBuilder().build());
  }
  public TaskRunStatusFluentImpl.ProvenanceNested<A> editOrNewProvenanceLike(Provenance item) {
    return withNewProvenanceLike(getProvenance() != null ? getProvenance(): item);
  }
  public A addToResults(int index,TaskRunResult item) {
    if (this.results == null) {this.results = new ArrayList<TaskRunResultBuilder>();}
    TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
    if (index < 0 || index >= results.size()) { _visitables.get("results").add(builder); results.add(builder); } else { _visitables.get("results").add(index, builder); results.add(index, builder);}
    return (A)this;
  }
  public A setToResults(int index,TaskRunResult item) {
    if (this.results == null) {this.results = new ArrayList<TaskRunResultBuilder>();}
    TaskRunResultBuilder builder = new TaskRunResultBuilder(item);
    if (index < 0 || index >= results.size()) { _visitables.get("results").add(builder); results.add(builder); } else { _visitables.get("results").set(index, builder); results.set(index, builder);}
    return (A)this;
  }
  public A addToResults(io.fabric8.tekton.pipeline.v1.TaskRunResult... items) {
    if (this.results == null) {this.results = new ArrayList<TaskRunResultBuilder>();}
    for (TaskRunResult item : items) {TaskRunResultBuilder builder = new TaskRunResultBuilder(item);_visitables.get("results").add(builder);this.results.add(builder);} return (A)this;
  }
  public A addAllToResults(Collection<TaskRunResult> items) {
    if (this.results == null) {this.results = new ArrayList<TaskRunResultBuilder>();}
    for (TaskRunResult item : items) {TaskRunResultBuilder builder = new TaskRunResultBuilder(item);_visitables.get("results").add(builder);this.results.add(builder);} return (A)this;
  }
  public A removeFromResults(io.fabric8.tekton.pipeline.v1.TaskRunResult... items) {
    for (TaskRunResult item : items) {TaskRunResultBuilder builder = new TaskRunResultBuilder(item);_visitables.get("results").remove(builder);if (this.results != null) {this.results.remove(builder);}} return (A)this;
  }
  public A removeAllFromResults(Collection<TaskRunResult> items) {
    for (TaskRunResult item : items) {TaskRunResultBuilder builder = new TaskRunResultBuilder(item);_visitables.get("results").remove(builder);if (this.results != null) {this.results.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResults(Predicate<TaskRunResultBuilder> predicate) {
    if (results == null) return (A) this;
    final Iterator<TaskRunResultBuilder> each = results.iterator();
    final List visitables = _visitables.get("results");
    while (each.hasNext()) {
      TaskRunResultBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResults instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TaskRunResult> getResults() {
    return results != null ? build(results) : null;
  }
  public List<TaskRunResult> buildResults() {
    return results != null ? build(results) : null;
  }
  public TaskRunResult buildResult(int index) {
    return this.results.get(index).build();
  }
  public TaskRunResult buildFirstResult() {
    return this.results.get(0).build();
  }
  public TaskRunResult buildLastResult() {
    return this.results.get(results.size() - 1).build();
  }
  public TaskRunResult buildMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
    for (TaskRunResultBuilder item: results) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
    for (TaskRunResultBuilder item: results) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResults(List<TaskRunResult> results) {
    if (this.results != null) { _visitables.get("results").clear();}
    if (results != null) {this.results = new ArrayList(); for (TaskRunResult item : results){this.addToResults(item);}} else { this.results = null;} return (A) this;
  }
  public A withResults(io.fabric8.tekton.pipeline.v1.TaskRunResult... results) {
    if (this.results != null) {this.results.clear(); _visitables.remove("results"); }
    if (results != null) {for (TaskRunResult item :results){ this.addToResults(item);}} return (A) this;
  }
  public Boolean hasResults() {
    return results != null && !results.isEmpty();
  }
  public TaskRunStatusFluentImpl.ResultsNested<A> addNewResult() {
    return new TaskRunStatusFluentImpl.ResultsNestedImpl();
  }
  public TaskRunStatusFluentImpl.ResultsNested<A> addNewResultLike(TaskRunResult item) {
    return new TaskRunStatusFluentImpl.ResultsNestedImpl(-1, item);
  }
  public TaskRunStatusFluentImpl.ResultsNested<A> setNewResultLike(int index,TaskRunResult item) {
    return new TaskRunStatusFluentImpl.ResultsNestedImpl(index, item);
  }
  public TaskRunStatusFluentImpl.ResultsNested<A> editResult(int index) {
    if (results.size() <= index) throw new RuntimeException("Can't edit results. Index exceeds size.");
    return setNewResultLike(index, buildResult(index));
  }
  public TaskRunStatusFluentImpl.ResultsNested<A> editFirstResult() {
    if (results.size() == 0) throw new RuntimeException("Can't edit first results. The list is empty.");
    return setNewResultLike(0, buildResult(0));
  }
  public TaskRunStatusFluentImpl.ResultsNested<A> editLastResult() {
    int index = results.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last results. The list is empty.");
    return setNewResultLike(index, buildResult(index));
  }
  public TaskRunStatusFluentImpl.ResultsNested<A> editMatchingResult(Predicate<TaskRunResultBuilder> predicate) {
    int index = -1;
    for (int i=0;i<results.size();i++) { 
    if (predicate.test(results.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching results. No match found.");
    return setNewResultLike(index, buildResult(index));
  }
  public A addToRetriesStatus(int index,TaskRunStatus item) {
    if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
    TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
    if (index < 0 || index >= retriesStatus.size()) { _visitables.get("retriesStatus").add(builder); retriesStatus.add(builder); } else { _visitables.get("retriesStatus").add(index, builder); retriesStatus.add(index, builder);}
    return (A)this;
  }
  public A setToRetriesStatus(int index,TaskRunStatus item) {
    if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
    TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);
    if (index < 0 || index >= retriesStatus.size()) { _visitables.get("retriesStatus").add(builder); retriesStatus.add(builder); } else { _visitables.get("retriesStatus").set(index, builder); retriesStatus.set(index, builder);}
    return (A)this;
  }
  public A addToRetriesStatus(io.fabric8.tekton.pipeline.v1.TaskRunStatus... items) {
    if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
    for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").add(builder);this.retriesStatus.add(builder);} return (A)this;
  }
  public A addAllToRetriesStatus(Collection<TaskRunStatus> items) {
    if (this.retriesStatus == null) {this.retriesStatus = new ArrayList<TaskRunStatusBuilder>();}
    for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").add(builder);this.retriesStatus.add(builder);} return (A)this;
  }
  public A removeFromRetriesStatus(io.fabric8.tekton.pipeline.v1.TaskRunStatus... items) {
    for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").remove(builder);if (this.retriesStatus != null) {this.retriesStatus.remove(builder);}} return (A)this;
  }
  public A removeAllFromRetriesStatus(Collection<TaskRunStatus> items) {
    for (TaskRunStatus item : items) {TaskRunStatusBuilder builder = new TaskRunStatusBuilder(item);_visitables.get("retriesStatus").remove(builder);if (this.retriesStatus != null) {this.retriesStatus.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
    if (retriesStatus == null) return (A) this;
    final Iterator<TaskRunStatusBuilder> each = retriesStatus.iterator();
    final List visitables = _visitables.get("retriesStatus");
    while (each.hasNext()) {
      TaskRunStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRetriesStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TaskRunStatus> getRetriesStatus() {
    return retriesStatus != null ? build(retriesStatus) : null;
  }
  public List<TaskRunStatus> buildRetriesStatus() {
    return retriesStatus != null ? build(retriesStatus) : null;
  }
  public TaskRunStatus buildRetriesStatus(int index) {
    return this.retriesStatus.get(index).build();
  }
  public TaskRunStatus buildFirstRetriesStatus() {
    return this.retriesStatus.get(0).build();
  }
  public TaskRunStatus buildLastRetriesStatus() {
    return this.retriesStatus.get(retriesStatus.size() - 1).build();
  }
  public TaskRunStatus buildMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
    for (TaskRunStatusBuilder item: retriesStatus) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
    for (TaskRunStatusBuilder item: retriesStatus) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRetriesStatus(List<TaskRunStatus> retriesStatus) {
    if (this.retriesStatus != null) { _visitables.get("retriesStatus").clear();}
    if (retriesStatus != null) {this.retriesStatus = new ArrayList(); for (TaskRunStatus item : retriesStatus){this.addToRetriesStatus(item);}} else { this.retriesStatus = null;} return (A) this;
  }
  public A withRetriesStatus(io.fabric8.tekton.pipeline.v1.TaskRunStatus... retriesStatus) {
    if (this.retriesStatus != null) {this.retriesStatus.clear(); _visitables.remove("retriesStatus"); }
    if (retriesStatus != null) {for (TaskRunStatus item :retriesStatus){ this.addToRetriesStatus(item);}} return (A) this;
  }
  public Boolean hasRetriesStatus() {
    return retriesStatus != null && !retriesStatus.isEmpty();
  }
  public TaskRunStatusFluentImpl.RetriesStatusNested<A> addNewRetriesStatus() {
    return new TaskRunStatusFluentImpl.RetriesStatusNestedImpl();
  }
  public TaskRunStatusFluentImpl.RetriesStatusNested<A> addNewRetriesStatusLike(TaskRunStatus item) {
    return new TaskRunStatusFluentImpl.RetriesStatusNestedImpl(-1, item);
  }
  public TaskRunStatusFluentImpl.RetriesStatusNested<A> setNewRetriesStatusLike(int index,TaskRunStatus item) {
    return new TaskRunStatusFluentImpl.RetriesStatusNestedImpl(index, item);
  }
  public TaskRunStatusFluentImpl.RetriesStatusNested<A> editRetriesStatus(int index) {
    if (retriesStatus.size() <= index) throw new RuntimeException("Can't edit retriesStatus. Index exceeds size.");
    return setNewRetriesStatusLike(index, buildRetriesStatus(index));
  }
  public TaskRunStatusFluentImpl.RetriesStatusNested<A> editFirstRetriesStatus() {
    if (retriesStatus.size() == 0) throw new RuntimeException("Can't edit first retriesStatus. The list is empty.");
    return setNewRetriesStatusLike(0, buildRetriesStatus(0));
  }
  public TaskRunStatusFluentImpl.RetriesStatusNested<A> editLastRetriesStatus() {
    int index = retriesStatus.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last retriesStatus. The list is empty.");
    return setNewRetriesStatusLike(index, buildRetriesStatus(index));
  }
  public TaskRunStatusFluentImpl.RetriesStatusNested<A> editMatchingRetriesStatus(Predicate<TaskRunStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<retriesStatus.size();i++) { 
    if (predicate.test(retriesStatus.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching retriesStatus. No match found.");
    return setNewRetriesStatusLike(index, buildRetriesStatus(index));
  }
  public A addToSidecars(int index,SidecarState item) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarStateBuilder>();}
    SidecarStateBuilder builder = new SidecarStateBuilder(item);
    if (index < 0 || index >= sidecars.size()) { _visitables.get("sidecars").add(builder); sidecars.add(builder); } else { _visitables.get("sidecars").add(index, builder); sidecars.add(index, builder);}
    return (A)this;
  }
  public A setToSidecars(int index,SidecarState item) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarStateBuilder>();}
    SidecarStateBuilder builder = new SidecarStateBuilder(item);
    if (index < 0 || index >= sidecars.size()) { _visitables.get("sidecars").add(builder); sidecars.add(builder); } else { _visitables.get("sidecars").set(index, builder); sidecars.set(index, builder);}
    return (A)this;
  }
  public A addToSidecars(io.fabric8.tekton.pipeline.v1.SidecarState... items) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarStateBuilder>();}
    for (SidecarState item : items) {SidecarStateBuilder builder = new SidecarStateBuilder(item);_visitables.get("sidecars").add(builder);this.sidecars.add(builder);} return (A)this;
  }
  public A addAllToSidecars(Collection<SidecarState> items) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<SidecarStateBuilder>();}
    for (SidecarState item : items) {SidecarStateBuilder builder = new SidecarStateBuilder(item);_visitables.get("sidecars").add(builder);this.sidecars.add(builder);} return (A)this;
  }
  public A removeFromSidecars(io.fabric8.tekton.pipeline.v1.SidecarState... items) {
    for (SidecarState item : items) {SidecarStateBuilder builder = new SidecarStateBuilder(item);_visitables.get("sidecars").remove(builder);if (this.sidecars != null) {this.sidecars.remove(builder);}} return (A)this;
  }
  public A removeAllFromSidecars(Collection<SidecarState> items) {
    for (SidecarState item : items) {SidecarStateBuilder builder = new SidecarStateBuilder(item);_visitables.get("sidecars").remove(builder);if (this.sidecars != null) {this.sidecars.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSidecars(Predicate<SidecarStateBuilder> predicate) {
    if (sidecars == null) return (A) this;
    final Iterator<SidecarStateBuilder> each = sidecars.iterator();
    final List visitables = _visitables.get("sidecars");
    while (each.hasNext()) {
      SidecarStateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSidecars instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SidecarState> getSidecars() {
    return sidecars != null ? build(sidecars) : null;
  }
  public List<SidecarState> buildSidecars() {
    return sidecars != null ? build(sidecars) : null;
  }
  public SidecarState buildSidecar(int index) {
    return this.sidecars.get(index).build();
  }
  public SidecarState buildFirstSidecar() {
    return this.sidecars.get(0).build();
  }
  public SidecarState buildLastSidecar() {
    return this.sidecars.get(sidecars.size() - 1).build();
  }
  public SidecarState buildMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
    for (SidecarStateBuilder item: sidecars) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
    for (SidecarStateBuilder item: sidecars) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSidecars(List<SidecarState> sidecars) {
    if (this.sidecars != null) { _visitables.get("sidecars").clear();}
    if (sidecars != null) {this.sidecars = new ArrayList(); for (SidecarState item : sidecars){this.addToSidecars(item);}} else { this.sidecars = null;} return (A) this;
  }
  public A withSidecars(io.fabric8.tekton.pipeline.v1.SidecarState... sidecars) {
    if (this.sidecars != null) {this.sidecars.clear(); _visitables.remove("sidecars"); }
    if (sidecars != null) {for (SidecarState item :sidecars){ this.addToSidecars(item);}} return (A) this;
  }
  public Boolean hasSidecars() {
    return sidecars != null && !sidecars.isEmpty();
  }
  public TaskRunStatusFluentImpl.SidecarsNested<A> addNewSidecar() {
    return new TaskRunStatusFluentImpl.SidecarsNestedImpl();
  }
  public TaskRunStatusFluentImpl.SidecarsNested<A> addNewSidecarLike(SidecarState item) {
    return new TaskRunStatusFluentImpl.SidecarsNestedImpl(-1, item);
  }
  public TaskRunStatusFluentImpl.SidecarsNested<A> setNewSidecarLike(int index,SidecarState item) {
    return new TaskRunStatusFluentImpl.SidecarsNestedImpl(index, item);
  }
  public TaskRunStatusFluentImpl.SidecarsNested<A> editSidecar(int index) {
    if (sidecars.size() <= index) throw new RuntimeException("Can't edit sidecars. Index exceeds size.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  public TaskRunStatusFluentImpl.SidecarsNested<A> editFirstSidecar() {
    if (sidecars.size() == 0) throw new RuntimeException("Can't edit first sidecars. The list is empty.");
    return setNewSidecarLike(0, buildSidecar(0));
  }
  public TaskRunStatusFluentImpl.SidecarsNested<A> editLastSidecar() {
    int index = sidecars.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sidecars. The list is empty.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  public TaskRunStatusFluentImpl.SidecarsNested<A> editMatchingSidecar(Predicate<SidecarStateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sidecars.size();i++) { 
    if (predicate.test(sidecars.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sidecars. No match found.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  public A addToSpanContext(String key,String value) {
    if(this.spanContext == null && key != null && value != null) { this.spanContext = new LinkedHashMap(); }
    if(key != null && value != null) {this.spanContext.put(key, value);} return (A)this;
  }
  public A addToSpanContext(Map<String,String> map) {
    if(this.spanContext == null && map != null) { this.spanContext = new LinkedHashMap(); }
    if(map != null) { this.spanContext.putAll(map);} return (A)this;
  }
  public A removeFromSpanContext(String key) {
    if(this.spanContext == null) { return (A) this; }
    if(key != null && this.spanContext != null) {this.spanContext.remove(key);} return (A)this;
  }
  public A removeFromSpanContext(Map<String,String> map) {
    if(this.spanContext == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.spanContext != null){this.spanContext.remove(key);}}} return (A)this;
  }
  public Map<String,String> getSpanContext() {
    return this.spanContext;
  }
  public <K,V>A withSpanContext(Map<String,String> spanContext) {
    if (spanContext == null) { this.spanContext =  null;} else {this.spanContext = new LinkedHashMap(spanContext);} return (A) this;
  }
  public Boolean hasSpanContext() {
    return this.spanContext != null;
  }
  public String getStartTime() {
    return this.startTime;
  }
  public A withStartTime(String startTime) {
    this.startTime=startTime; return (A) this;
  }
  public Boolean hasStartTime() {
    return this.startTime != null;
  }
  public A addToSteps(int index,StepState item) {
    if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
    StepStateBuilder builder = new StepStateBuilder(item);
    if (index < 0 || index >= steps.size()) { _visitables.get("steps").add(builder); steps.add(builder); } else { _visitables.get("steps").add(index, builder); steps.add(index, builder);}
    return (A)this;
  }
  public A setToSteps(int index,StepState item) {
    if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
    StepStateBuilder builder = new StepStateBuilder(item);
    if (index < 0 || index >= steps.size()) { _visitables.get("steps").add(builder); steps.add(builder); } else { _visitables.get("steps").set(index, builder); steps.set(index, builder);}
    return (A)this;
  }
  public A addToSteps(io.fabric8.tekton.pipeline.v1.StepState... items) {
    if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
    for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
  }
  public A addAllToSteps(Collection<StepState> items) {
    if (this.steps == null) {this.steps = new ArrayList<StepStateBuilder>();}
    for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
  }
  public A removeFromSteps(io.fabric8.tekton.pipeline.v1.StepState... items) {
    for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
  }
  public A removeAllFromSteps(Collection<StepState> items) {
    for (StepState item : items) {StepStateBuilder builder = new StepStateBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSteps(Predicate<StepStateBuilder> predicate) {
    if (steps == null) return (A) this;
    final Iterator<StepStateBuilder> each = steps.iterator();
    final List visitables = _visitables.get("steps");
    while (each.hasNext()) {
      StepStateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSteps instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<StepState> getSteps() {
    return steps != null ? build(steps) : null;
  }
  public List<StepState> buildSteps() {
    return steps != null ? build(steps) : null;
  }
  public StepState buildStep(int index) {
    return this.steps.get(index).build();
  }
  public StepState buildFirstStep() {
    return this.steps.get(0).build();
  }
  public StepState buildLastStep() {
    return this.steps.get(steps.size() - 1).build();
  }
  public StepState buildMatchingStep(Predicate<StepStateBuilder> predicate) {
    for (StepStateBuilder item: steps) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingStep(Predicate<StepStateBuilder> predicate) {
    for (StepStateBuilder item: steps) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSteps(List<StepState> steps) {
    if (this.steps != null) { _visitables.get("steps").clear();}
    if (steps != null) {this.steps = new ArrayList(); for (StepState item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
  }
  public A withSteps(io.fabric8.tekton.pipeline.v1.StepState... steps) {
    if (this.steps != null) {this.steps.clear(); _visitables.remove("steps"); }
    if (steps != null) {for (StepState item :steps){ this.addToSteps(item);}} return (A) this;
  }
  public Boolean hasSteps() {
    return steps != null && !steps.isEmpty();
  }
  public TaskRunStatusFluentImpl.StepsNested<A> addNewStep() {
    return new TaskRunStatusFluentImpl.StepsNestedImpl();
  }
  public TaskRunStatusFluentImpl.StepsNested<A> addNewStepLike(StepState item) {
    return new TaskRunStatusFluentImpl.StepsNestedImpl(-1, item);
  }
  public TaskRunStatusFluentImpl.StepsNested<A> setNewStepLike(int index,StepState item) {
    return new TaskRunStatusFluentImpl.StepsNestedImpl(index, item);
  }
  public TaskRunStatusFluentImpl.StepsNested<A> editStep(int index) {
    if (steps.size() <= index) throw new RuntimeException("Can't edit steps. Index exceeds size.");
    return setNewStepLike(index, buildStep(index));
  }
  public TaskRunStatusFluentImpl.StepsNested<A> editFirstStep() {
    if (steps.size() == 0) throw new RuntimeException("Can't edit first steps. The list is empty.");
    return setNewStepLike(0, buildStep(0));
  }
  public TaskRunStatusFluentImpl.StepsNested<A> editLastStep() {
    int index = steps.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last steps. The list is empty.");
    return setNewStepLike(index, buildStep(index));
  }
  public TaskRunStatusFluentImpl.StepsNested<A> editMatchingStep(Predicate<StepStateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<steps.size();i++) { 
    if (predicate.test(steps.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching steps. No match found.");
    return setNewStepLike(index, buildStep(index));
  }
  
  /**
   * This method has been deprecated, please use method buildTaskSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public TaskSpec getTaskSpec() {
    return this.taskSpec!=null ?this.taskSpec.build():null;
  }
  public TaskSpec buildTaskSpec() {
    return this.taskSpec!=null ?this.taskSpec.build():null;
  }
  public A withTaskSpec(TaskSpec taskSpec) {
    _visitables.get("taskSpec").remove(this.taskSpec);
    if (taskSpec!=null){ this.taskSpec= new TaskSpecBuilder(taskSpec); _visitables.get("taskSpec").add(this.taskSpec);} else { this.taskSpec = null; _visitables.get("taskSpec").remove(this.taskSpec); } return (A) this;
  }
  public Boolean hasTaskSpec() {
    return this.taskSpec != null;
  }
  public TaskRunStatusFluentImpl.TaskSpecNested<A> withNewTaskSpec() {
    return new TaskRunStatusFluentImpl.TaskSpecNestedImpl();
  }
  public TaskRunStatusFluentImpl.TaskSpecNested<A> withNewTaskSpecLike(TaskSpec item) {
    return new TaskRunStatusFluentImpl.TaskSpecNestedImpl(item);
  }
  public TaskRunStatusFluentImpl.TaskSpecNested<A> editTaskSpec() {
    return withNewTaskSpecLike(getTaskSpec());
  }
  public TaskRunStatusFluentImpl.TaskSpecNested<A> editOrNewTaskSpec() {
    return withNewTaskSpecLike(getTaskSpec() != null ? getTaskSpec(): new TaskSpecBuilder().build());
  }
  public TaskRunStatusFluentImpl.TaskSpecNested<A> editOrNewTaskSpecLike(TaskSpec item) {
    return withNewTaskSpecLike(getTaskSpec() != null ? getTaskSpec(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TaskRunStatusFluentImpl that = (TaskRunStatusFluentImpl) o;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(completionTime, that.completionTime)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(podName, that.podName)) return false;

    if (!java.util.Objects.equals(provenance, that.provenance)) return false;

    if (!java.util.Objects.equals(results, that.results)) return false;

    if (!java.util.Objects.equals(retriesStatus, that.retriesStatus)) return false;

    if (!java.util.Objects.equals(sidecars, that.sidecars)) return false;

    if (!java.util.Objects.equals(spanContext, that.spanContext)) return false;

    if (!java.util.Objects.equals(startTime, that.startTime)) return false;

    if (!java.util.Objects.equals(steps, that.steps)) return false;

    if (!java.util.Objects.equals(taskSpec, that.taskSpec)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  completionTime,  conditions,  observedGeneration,  podName,  provenance,  results,  retriesStatus,  sidecars,  spanContext,  startTime,  steps,  taskSpec,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (completionTime != null) { sb.append("completionTime:"); sb.append(completionTime + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (podName != null) { sb.append("podName:"); sb.append(podName + ","); }
    if (provenance != null) { sb.append("provenance:"); sb.append(provenance + ","); }
    if (results != null) { sb.append("results:"); sb.append(results + ","); }
    if (retriesStatus != null) { sb.append("retriesStatus:"); sb.append(retriesStatus + ","); }
    if (sidecars != null) { sb.append("sidecars:"); sb.append(sidecars + ","); }
    if (spanContext != null && !spanContext.isEmpty()) { sb.append("spanContext:"); sb.append(spanContext + ","); }
    if (startTime != null) { sb.append("startTime:"); sb.append(startTime + ","); }
    if (steps != null) { sb.append("steps:"); sb.append(steps + ","); }
    if (taskSpec != null) { sb.append("taskSpec:"); sb.append(taskSpec); }
    sb.append("}");
    return sb.toString();
  }
  class ProvenanceNestedImpl<N> extends ProvenanceFluentImpl<TaskRunStatusFluentImpl.ProvenanceNested<N>> implements TaskRunStatusFluentImpl.ProvenanceNested<N>,Nested<N>{
    ProvenanceNestedImpl(Provenance item) {
      this.builder = new ProvenanceBuilder(this, item);
    }
    ProvenanceNestedImpl() {
      this.builder = new ProvenanceBuilder(this);
    }
    ProvenanceBuilder builder;
    public N and() {
      return (N) TaskRunStatusFluentImpl.this.withProvenance(builder.build());
    }
    public N endProvenance() {
      return and();
    }
    
  }
  class ResultsNestedImpl<N> extends TaskRunResultFluentImpl<TaskRunStatusFluentImpl.ResultsNested<N>> implements TaskRunStatusFluentImpl.ResultsNested<N>,Nested<N>{
    ResultsNestedImpl(int index,TaskRunResult item) {
      this.index = index;
      this.builder = new TaskRunResultBuilder(this, item);
    }
    ResultsNestedImpl() {
      this.index = -1;
      this.builder = new TaskRunResultBuilder(this);
    }
    TaskRunResultBuilder builder;
    int index;
    public N and() {
      return (N) TaskRunStatusFluentImpl.this.setToResults(index,builder.build());
    }
    public N endResult() {
      return and();
    }
    
  }
  class RetriesStatusNestedImpl<N> extends TaskRunStatusFluentImpl<TaskRunStatusFluentImpl.RetriesStatusNested<N>> implements TaskRunStatusFluentImpl.RetriesStatusNested<N>,Nested<N>{
    RetriesStatusNestedImpl(int index,TaskRunStatus item) {
      this.index = index;
      this.builder = new TaskRunStatusBuilder(this, item);
    }
    RetriesStatusNestedImpl() {
      this.index = -1;
      this.builder = new TaskRunStatusBuilder(this);
    }
    TaskRunStatusBuilder builder;
    int index;
    public N and() {
      return (N) TaskRunStatusFluentImpl.this.setToRetriesStatus(index,builder.build());
    }
    public N endRetriesStatus() {
      return and();
    }
    
  }
  class SidecarsNestedImpl<N> extends SidecarStateFluentImpl<TaskRunStatusFluentImpl.SidecarsNested<N>> implements TaskRunStatusFluentImpl.SidecarsNested<N>,Nested<N>{
    SidecarsNestedImpl(int index,SidecarState item) {
      this.index = index;
      this.builder = new SidecarStateBuilder(this, item);
    }
    SidecarsNestedImpl() {
      this.index = -1;
      this.builder = new SidecarStateBuilder(this);
    }
    SidecarStateBuilder builder;
    int index;
    public N and() {
      return (N) TaskRunStatusFluentImpl.this.setToSidecars(index,builder.build());
    }
    public N endSidecar() {
      return and();
    }
    
  }
  class StepsNestedImpl<N> extends StepStateFluentImpl<TaskRunStatusFluentImpl.StepsNested<N>> implements TaskRunStatusFluentImpl.StepsNested<N>,Nested<N>{
    StepsNestedImpl(int index,StepState item) {
      this.index = index;
      this.builder = new StepStateBuilder(this, item);
    }
    StepsNestedImpl() {
      this.index = -1;
      this.builder = new StepStateBuilder(this);
    }
    StepStateBuilder builder;
    int index;
    public N and() {
      return (N) TaskRunStatusFluentImpl.this.setToSteps(index,builder.build());
    }
    public N endStep() {
      return and();
    }
    
  }
  class TaskSpecNestedImpl<N> extends TaskSpecFluentImpl<TaskRunStatusFluentImpl.TaskSpecNested<N>> implements TaskRunStatusFluentImpl.TaskSpecNested<N>,Nested<N>{
    TaskSpecNestedImpl(TaskSpec item) {
      this.builder = new TaskSpecBuilder(this, item);
    }
    TaskSpecNestedImpl() {
      this.builder = new TaskSpecBuilder(this);
    }
    TaskSpecBuilder builder;
    public N and() {
      return (N) TaskRunStatusFluentImpl.this.withTaskSpec(builder.build());
    }
    public N endTaskSpec() {
      return and();
    }
    
  }
  
}