package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskRunStatusBuilder extends TaskRunStatusFluentImpl<TaskRunStatusBuilder> implements VisitableBuilder<TaskRunStatus,TaskRunStatusBuilder>{
  public TaskRunStatusBuilder() {
    this(false);
  }
  public TaskRunStatusBuilder(Boolean validationEnabled) {
    this(new TaskRunStatus(), validationEnabled);
  }
  public TaskRunStatusBuilder(TaskRunStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskRunStatusBuilder(TaskRunStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TaskRunStatus(), validationEnabled);
  }
  public TaskRunStatusBuilder(TaskRunStatusFluent<?> fluent,TaskRunStatus instance) {
    this(fluent, instance, false);
  }
  public TaskRunStatusBuilder(TaskRunStatusFluent<?> fluent,TaskRunStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withCompletionTime(instance.getCompletionTime());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withPodName(instance.getPodName());
      fluent.withProvenance(instance.getProvenance());
      fluent.withResults(instance.getResults());
      fluent.withRetriesStatus(instance.getRetriesStatus());
      fluent.withSidecars(instance.getSidecars());
      fluent.withSpanContext(instance.getSpanContext());
      fluent.withStartTime(instance.getStartTime());
      fluent.withSteps(instance.getSteps());
      fluent.withTaskSpec(instance.getTaskSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaskRunStatusBuilder(TaskRunStatus instance) {
    this(instance,false);
  }
  public TaskRunStatusBuilder(TaskRunStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withCompletionTime(instance.getCompletionTime());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withPodName(instance.getPodName());
      this.withProvenance(instance.getProvenance());
      this.withResults(instance.getResults());
      this.withRetriesStatus(instance.getRetriesStatus());
      this.withSidecars(instance.getSidecars());
      this.withSpanContext(instance.getSpanContext());
      this.withStartTime(instance.getStartTime());
      this.withSteps(instance.getSteps());
      this.withTaskSpec(instance.getTaskSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaskRunStatusFluent<?> fluent;
  Boolean validationEnabled;
  public TaskRunStatus build() {
    TaskRunStatus buildable = new TaskRunStatus(fluent.getAnnotations(),fluent.getCompletionTime(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getPodName(),fluent.getProvenance(),fluent.getResults(),fluent.getRetriesStatus(),fluent.getSidecars(),fluent.getSpanContext(),fluent.getStartTime(),fluent.getSteps(),fluent.getTaskSpec());
    return buildable;
  }
  
}