package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.tekton.v1.internal.pipeline.pkg.apis.pipeline.pod.TemplateBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.tekton.v1.internal.pipeline.pkg.apis.pipeline.pod.Template;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.Collection;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.v1.internal.pipeline.pkg.apis.pipeline.pod.TemplateFluentImpl;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TaskRunSpecFluentImpl<A extends TaskRunSpecFluent<A>> extends BaseFluent<A> implements TaskRunSpecFluent<A>{
  public TaskRunSpecFluentImpl() {
  }
  public TaskRunSpecFluentImpl(TaskRunSpec instance) {
    if (instance != null) {
      this.withComputeResources(instance.getComputeResources());
      this.withDebug(instance.getDebug());
      this.withParams(instance.getParams());
      this.withPodTemplate(instance.getPodTemplate());
      this.withRetries(instance.getRetries());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSidecarSpecs(instance.getSidecarSpecs());
      this.withStatus(instance.getStatus());
      this.withStatusMessage(instance.getStatusMessage());
      this.withStepSpecs(instance.getStepSpecs());
      this.withTaskRef(instance.getTaskRef());
      this.withTaskSpec(instance.getTaskSpec());
      this.withTimeout(instance.getTimeout());
      this.withWorkspaces(instance.getWorkspaces());
    }
  }
  private ResourceRequirementsBuilder computeResources;
  private TaskRunDebugBuilder debug;
  private ArrayList<ParamBuilder> params = new ArrayList<ParamBuilder>();
  private TemplateBuilder podTemplate;
  private Integer retries;
  private String serviceAccountName;
  private ArrayList<TaskRunSidecarSpecBuilder> sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();
  private String status;
  private String statusMessage;
  private ArrayList<TaskRunStepSpecBuilder> stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();
  private TaskRefBuilder taskRef;
  private TaskSpecBuilder taskSpec;
  private Duration timeout;
  private ArrayList<WorkspaceBindingBuilder> workspaces = new ArrayList<WorkspaceBindingBuilder>();
  
  /**
   * This method has been deprecated, please use method buildComputeResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getComputeResources() {
    return this.computeResources!=null ?this.computeResources.build():null;
  }
  public ResourceRequirements buildComputeResources() {
    return this.computeResources!=null ?this.computeResources.build():null;
  }
  public A withComputeResources(ResourceRequirements computeResources) {
    _visitables.get("computeResources").remove(this.computeResources);
    if (computeResources!=null){ this.computeResources= new ResourceRequirementsBuilder(computeResources); _visitables.get("computeResources").add(this.computeResources);} else { this.computeResources = null; _visitables.get("computeResources").remove(this.computeResources); } return (A) this;
  }
  public Boolean hasComputeResources() {
    return this.computeResources != null;
  }
  public TaskRunSpecFluentImpl.ComputeResourcesNested<A> withNewComputeResources() {
    return new TaskRunSpecFluentImpl.ComputeResourcesNestedImpl();
  }
  public TaskRunSpecFluentImpl.ComputeResourcesNested<A> withNewComputeResourcesLike(ResourceRequirements item) {
    return new TaskRunSpecFluentImpl.ComputeResourcesNestedImpl(item);
  }
  public TaskRunSpecFluentImpl.ComputeResourcesNested<A> editComputeResources() {
    return withNewComputeResourcesLike(getComputeResources());
  }
  public TaskRunSpecFluentImpl.ComputeResourcesNested<A> editOrNewComputeResources() {
    return withNewComputeResourcesLike(getComputeResources() != null ? getComputeResources(): new ResourceRequirementsBuilder().build());
  }
  public TaskRunSpecFluentImpl.ComputeResourcesNested<A> editOrNewComputeResourcesLike(ResourceRequirements item) {
    return withNewComputeResourcesLike(getComputeResources() != null ? getComputeResources(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDebug instead.
   * @return The buildable object.
   */
  @Deprecated
  public TaskRunDebug getDebug() {
    return this.debug!=null ?this.debug.build():null;
  }
  public TaskRunDebug buildDebug() {
    return this.debug!=null ?this.debug.build():null;
  }
  public A withDebug(TaskRunDebug debug) {
    _visitables.get("debug").remove(this.debug);
    if (debug!=null){ this.debug= new TaskRunDebugBuilder(debug); _visitables.get("debug").add(this.debug);} else { this.debug = null; _visitables.get("debug").remove(this.debug); } return (A) this;
  }
  public Boolean hasDebug() {
    return this.debug != null;
  }
  public TaskRunSpecFluentImpl.DebugNested<A> withNewDebug() {
    return new TaskRunSpecFluentImpl.DebugNestedImpl();
  }
  public TaskRunSpecFluentImpl.DebugNested<A> withNewDebugLike(TaskRunDebug item) {
    return new TaskRunSpecFluentImpl.DebugNestedImpl(item);
  }
  public TaskRunSpecFluentImpl.DebugNested<A> editDebug() {
    return withNewDebugLike(getDebug());
  }
  public TaskRunSpecFluentImpl.DebugNested<A> editOrNewDebug() {
    return withNewDebugLike(getDebug() != null ? getDebug(): new TaskRunDebugBuilder().build());
  }
  public TaskRunSpecFluentImpl.DebugNested<A> editOrNewDebugLike(TaskRunDebug item) {
    return withNewDebugLike(getDebug() != null ? getDebug(): item);
  }
  public A addToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").add(index, builder); params.add(index, builder);}
    return (A)this;
  }
  public A setToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").set(index, builder); params.set(index, builder);}
    return (A)this;
  }
  public A addToParams(io.fabric8.tekton.pipeline.v1.Param... items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  public A addAllToParams(Collection<Param> items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  public A removeFromParams(io.fabric8.tekton.pipeline.v1.Param... items) {
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
  }
  public A removeAllFromParams(Collection<Param> items) {
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromParams(Predicate<ParamBuilder> predicate) {
    if (params == null) return (A) this;
    final Iterator<ParamBuilder> each = params.iterator();
    final List visitables = _visitables.get("params");
    while (each.hasNext()) {
      ParamBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildParams instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Param> getParams() {
    return params != null ? build(params) : null;
  }
  public List<Param> buildParams() {
    return params != null ? build(params) : null;
  }
  public Param buildParam(int index) {
    return this.params.get(index).build();
  }
  public Param buildFirstParam() {
    return this.params.get(0).build();
  }
  public Param buildLastParam() {
    return this.params.get(params.size() - 1).build();
  }
  public Param buildMatchingParam(Predicate<ParamBuilder> predicate) {
    for (ParamBuilder item: params) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingParam(Predicate<ParamBuilder> predicate) {
    for (ParamBuilder item: params) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParams(List<Param> params) {
    if (this.params != null) { _visitables.get("params").clear();}
    if (params != null) {this.params = new ArrayList(); for (Param item : params){this.addToParams(item);}} else { this.params = null;} return (A) this;
  }
  public A withParams(io.fabric8.tekton.pipeline.v1.Param... params) {
    if (this.params != null) {this.params.clear(); _visitables.remove("params"); }
    if (params != null) {for (Param item :params){ this.addToParams(item);}} return (A) this;
  }
  public Boolean hasParams() {
    return params != null && !params.isEmpty();
  }
  public TaskRunSpecFluentImpl.ParamsNested<A> addNewParam() {
    return new TaskRunSpecFluentImpl.ParamsNestedImpl();
  }
  public TaskRunSpecFluentImpl.ParamsNested<A> addNewParamLike(Param item) {
    return new TaskRunSpecFluentImpl.ParamsNestedImpl(-1, item);
  }
  public TaskRunSpecFluentImpl.ParamsNested<A> setNewParamLike(int index,Param item) {
    return new TaskRunSpecFluentImpl.ParamsNestedImpl(index, item);
  }
  public TaskRunSpecFluentImpl.ParamsNested<A> editParam(int index) {
    if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
    return setNewParamLike(index, buildParam(index));
  }
  public TaskRunSpecFluentImpl.ParamsNested<A> editFirstParam() {
    if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
    return setNewParamLike(0, buildParam(0));
  }
  public TaskRunSpecFluentImpl.ParamsNested<A> editLastParam() {
    int index = params.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
    return setNewParamLike(index, buildParam(index));
  }
  public TaskRunSpecFluentImpl.ParamsNested<A> editMatchingParam(Predicate<ParamBuilder> predicate) {
    int index = -1;
    for (int i=0;i<params.size();i++) { 
    if (predicate.test(params.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
    return setNewParamLike(index, buildParam(index));
  }
  
  /**
   * This method has been deprecated, please use method buildPodTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public Template getPodTemplate() {
    return this.podTemplate!=null ?this.podTemplate.build():null;
  }
  public Template buildPodTemplate() {
    return this.podTemplate!=null ?this.podTemplate.build():null;
  }
  public A withPodTemplate(Template podTemplate) {
    _visitables.get("podTemplate").remove(this.podTemplate);
    if (podTemplate!=null){ this.podTemplate= new TemplateBuilder(podTemplate); _visitables.get("podTemplate").add(this.podTemplate);} else { this.podTemplate = null; _visitables.get("podTemplate").remove(this.podTemplate); } return (A) this;
  }
  public Boolean hasPodTemplate() {
    return this.podTemplate != null;
  }
  public TaskRunSpecFluentImpl.PodTemplateNested<A> withNewPodTemplate() {
    return new TaskRunSpecFluentImpl.PodTemplateNestedImpl();
  }
  public TaskRunSpecFluentImpl.PodTemplateNested<A> withNewPodTemplateLike(Template item) {
    return new TaskRunSpecFluentImpl.PodTemplateNestedImpl(item);
  }
  public TaskRunSpecFluentImpl.PodTemplateNested<A> editPodTemplate() {
    return withNewPodTemplateLike(getPodTemplate());
  }
  public TaskRunSpecFluentImpl.PodTemplateNested<A> editOrNewPodTemplate() {
    return withNewPodTemplateLike(getPodTemplate() != null ? getPodTemplate(): new TemplateBuilder().build());
  }
  public TaskRunSpecFluentImpl.PodTemplateNested<A> editOrNewPodTemplateLike(Template item) {
    return withNewPodTemplateLike(getPodTemplate() != null ? getPodTemplate(): item);
  }
  public Integer getRetries() {
    return this.retries;
  }
  public A withRetries(Integer retries) {
    this.retries=retries; return (A) this;
  }
  public Boolean hasRetries() {
    return this.retries != null;
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  public A addToSidecarSpecs(int index,TaskRunSidecarSpec item) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
    if (index < 0 || index >= sidecarSpecs.size()) { _visitables.get("sidecarSpecs").add(builder); sidecarSpecs.add(builder); } else { _visitables.get("sidecarSpecs").add(index, builder); sidecarSpecs.add(index, builder);}
    return (A)this;
  }
  public A setToSidecarSpecs(int index,TaskRunSidecarSpec item) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
    if (index < 0 || index >= sidecarSpecs.size()) { _visitables.get("sidecarSpecs").add(builder); sidecarSpecs.add(builder); } else { _visitables.get("sidecarSpecs").set(index, builder); sidecarSpecs.set(index, builder);}
    return (A)this;
  }
  public A addToSidecarSpecs(io.fabric8.tekton.pipeline.v1.TaskRunSidecarSpec... items) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").add(builder);this.sidecarSpecs.add(builder);} return (A)this;
  }
  public A addAllToSidecarSpecs(Collection<TaskRunSidecarSpec> items) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").add(builder);this.sidecarSpecs.add(builder);} return (A)this;
  }
  public A removeFromSidecarSpecs(io.fabric8.tekton.pipeline.v1.TaskRunSidecarSpec... items) {
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").remove(builder);if (this.sidecarSpecs != null) {this.sidecarSpecs.remove(builder);}} return (A)this;
  }
  public A removeAllFromSidecarSpecs(Collection<TaskRunSidecarSpec> items) {
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").remove(builder);if (this.sidecarSpecs != null) {this.sidecarSpecs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSidecarSpecs(Predicate<TaskRunSidecarSpecBuilder> predicate) {
    if (sidecarSpecs == null) return (A) this;
    final Iterator<TaskRunSidecarSpecBuilder> each = sidecarSpecs.iterator();
    final List visitables = _visitables.get("sidecarSpecs");
    while (each.hasNext()) {
      TaskRunSidecarSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSidecarSpecs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TaskRunSidecarSpec> getSidecarSpecs() {
    return sidecarSpecs != null ? build(sidecarSpecs) : null;
  }
  public List<TaskRunSidecarSpec> buildSidecarSpecs() {
    return sidecarSpecs != null ? build(sidecarSpecs) : null;
  }
  public TaskRunSidecarSpec buildSidecarSpec(int index) {
    return this.sidecarSpecs.get(index).build();
  }
  public TaskRunSidecarSpec buildFirstSidecarSpec() {
    return this.sidecarSpecs.get(0).build();
  }
  public TaskRunSidecarSpec buildLastSidecarSpec() {
    return this.sidecarSpecs.get(sidecarSpecs.size() - 1).build();
  }
  public TaskRunSidecarSpec buildMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
    for (TaskRunSidecarSpecBuilder item: sidecarSpecs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
    for (TaskRunSidecarSpecBuilder item: sidecarSpecs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSidecarSpecs(List<TaskRunSidecarSpec> sidecarSpecs) {
    if (this.sidecarSpecs != null) { _visitables.get("sidecarSpecs").clear();}
    if (sidecarSpecs != null) {this.sidecarSpecs = new ArrayList(); for (TaskRunSidecarSpec item : sidecarSpecs){this.addToSidecarSpecs(item);}} else { this.sidecarSpecs = null;} return (A) this;
  }
  public A withSidecarSpecs(io.fabric8.tekton.pipeline.v1.TaskRunSidecarSpec... sidecarSpecs) {
    if (this.sidecarSpecs != null) {this.sidecarSpecs.clear(); _visitables.remove("sidecarSpecs"); }
    if (sidecarSpecs != null) {for (TaskRunSidecarSpec item :sidecarSpecs){ this.addToSidecarSpecs(item);}} return (A) this;
  }
  public Boolean hasSidecarSpecs() {
    return sidecarSpecs != null && !sidecarSpecs.isEmpty();
  }
  public TaskRunSpecFluentImpl.SidecarSpecsNested<A> addNewSidecarSpec() {
    return new TaskRunSpecFluentImpl.SidecarSpecsNestedImpl();
  }
  public TaskRunSpecFluentImpl.SidecarSpecsNested<A> addNewSidecarSpecLike(TaskRunSidecarSpec item) {
    return new TaskRunSpecFluentImpl.SidecarSpecsNestedImpl(-1, item);
  }
  public TaskRunSpecFluentImpl.SidecarSpecsNested<A> setNewSidecarSpecLike(int index,TaskRunSidecarSpec item) {
    return new TaskRunSpecFluentImpl.SidecarSpecsNestedImpl(index, item);
  }
  public TaskRunSpecFluentImpl.SidecarSpecsNested<A> editSidecarSpec(int index) {
    if (sidecarSpecs.size() <= index) throw new RuntimeException("Can't edit sidecarSpecs. Index exceeds size.");
    return setNewSidecarSpecLike(index, buildSidecarSpec(index));
  }
  public TaskRunSpecFluentImpl.SidecarSpecsNested<A> editFirstSidecarSpec() {
    if (sidecarSpecs.size() == 0) throw new RuntimeException("Can't edit first sidecarSpecs. The list is empty.");
    return setNewSidecarSpecLike(0, buildSidecarSpec(0));
  }
  public TaskRunSpecFluentImpl.SidecarSpecsNested<A> editLastSidecarSpec() {
    int index = sidecarSpecs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sidecarSpecs. The list is empty.");
    return setNewSidecarSpecLike(index, buildSidecarSpec(index));
  }
  public TaskRunSpecFluentImpl.SidecarSpecsNested<A> editMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sidecarSpecs.size();i++) { 
    if (predicate.test(sidecarSpecs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sidecarSpecs. No match found.");
    return setNewSidecarSpecLike(index, buildSidecarSpec(index));
  }
  public String getStatus() {
    return this.status;
  }
  public A withStatus(String status) {
    this.status=status; return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public String getStatusMessage() {
    return this.statusMessage;
  }
  public A withStatusMessage(String statusMessage) {
    this.statusMessage=statusMessage; return (A) this;
  }
  public Boolean hasStatusMessage() {
    return this.statusMessage != null;
  }
  public A addToStepSpecs(int index,TaskRunStepSpec item) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
    if (index < 0 || index >= stepSpecs.size()) { _visitables.get("stepSpecs").add(builder); stepSpecs.add(builder); } else { _visitables.get("stepSpecs").add(index, builder); stepSpecs.add(index, builder);}
    return (A)this;
  }
  public A setToStepSpecs(int index,TaskRunStepSpec item) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
    if (index < 0 || index >= stepSpecs.size()) { _visitables.get("stepSpecs").add(builder); stepSpecs.add(builder); } else { _visitables.get("stepSpecs").set(index, builder); stepSpecs.set(index, builder);}
    return (A)this;
  }
  public A addToStepSpecs(io.fabric8.tekton.pipeline.v1.TaskRunStepSpec... items) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").add(builder);this.stepSpecs.add(builder);} return (A)this;
  }
  public A addAllToStepSpecs(Collection<TaskRunStepSpec> items) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").add(builder);this.stepSpecs.add(builder);} return (A)this;
  }
  public A removeFromStepSpecs(io.fabric8.tekton.pipeline.v1.TaskRunStepSpec... items) {
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").remove(builder);if (this.stepSpecs != null) {this.stepSpecs.remove(builder);}} return (A)this;
  }
  public A removeAllFromStepSpecs(Collection<TaskRunStepSpec> items) {
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").remove(builder);if (this.stepSpecs != null) {this.stepSpecs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromStepSpecs(Predicate<TaskRunStepSpecBuilder> predicate) {
    if (stepSpecs == null) return (A) this;
    final Iterator<TaskRunStepSpecBuilder> each = stepSpecs.iterator();
    final List visitables = _visitables.get("stepSpecs");
    while (each.hasNext()) {
      TaskRunStepSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildStepSpecs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TaskRunStepSpec> getStepSpecs() {
    return stepSpecs != null ? build(stepSpecs) : null;
  }
  public List<TaskRunStepSpec> buildStepSpecs() {
    return stepSpecs != null ? build(stepSpecs) : null;
  }
  public TaskRunStepSpec buildStepSpec(int index) {
    return this.stepSpecs.get(index).build();
  }
  public TaskRunStepSpec buildFirstStepSpec() {
    return this.stepSpecs.get(0).build();
  }
  public TaskRunStepSpec buildLastStepSpec() {
    return this.stepSpecs.get(stepSpecs.size() - 1).build();
  }
  public TaskRunStepSpec buildMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
    for (TaskRunStepSpecBuilder item: stepSpecs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
    for (TaskRunStepSpecBuilder item: stepSpecs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withStepSpecs(List<TaskRunStepSpec> stepSpecs) {
    if (this.stepSpecs != null) { _visitables.get("stepSpecs").clear();}
    if (stepSpecs != null) {this.stepSpecs = new ArrayList(); for (TaskRunStepSpec item : stepSpecs){this.addToStepSpecs(item);}} else { this.stepSpecs = null;} return (A) this;
  }
  public A withStepSpecs(io.fabric8.tekton.pipeline.v1.TaskRunStepSpec... stepSpecs) {
    if (this.stepSpecs != null) {this.stepSpecs.clear(); _visitables.remove("stepSpecs"); }
    if (stepSpecs != null) {for (TaskRunStepSpec item :stepSpecs){ this.addToStepSpecs(item);}} return (A) this;
  }
  public Boolean hasStepSpecs() {
    return stepSpecs != null && !stepSpecs.isEmpty();
  }
  public TaskRunSpecFluentImpl.StepSpecsNested<A> addNewStepSpec() {
    return new TaskRunSpecFluentImpl.StepSpecsNestedImpl();
  }
  public TaskRunSpecFluentImpl.StepSpecsNested<A> addNewStepSpecLike(TaskRunStepSpec item) {
    return new TaskRunSpecFluentImpl.StepSpecsNestedImpl(-1, item);
  }
  public TaskRunSpecFluentImpl.StepSpecsNested<A> setNewStepSpecLike(int index,TaskRunStepSpec item) {
    return new TaskRunSpecFluentImpl.StepSpecsNestedImpl(index, item);
  }
  public TaskRunSpecFluentImpl.StepSpecsNested<A> editStepSpec(int index) {
    if (stepSpecs.size() <= index) throw new RuntimeException("Can't edit stepSpecs. Index exceeds size.");
    return setNewStepSpecLike(index, buildStepSpec(index));
  }
  public TaskRunSpecFluentImpl.StepSpecsNested<A> editFirstStepSpec() {
    if (stepSpecs.size() == 0) throw new RuntimeException("Can't edit first stepSpecs. The list is empty.");
    return setNewStepSpecLike(0, buildStepSpec(0));
  }
  public TaskRunSpecFluentImpl.StepSpecsNested<A> editLastStepSpec() {
    int index = stepSpecs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last stepSpecs. The list is empty.");
    return setNewStepSpecLike(index, buildStepSpec(index));
  }
  public TaskRunSpecFluentImpl.StepSpecsNested<A> editMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<stepSpecs.size();i++) { 
    if (predicate.test(stepSpecs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching stepSpecs. No match found.");
    return setNewStepSpecLike(index, buildStepSpec(index));
  }
  
  /**
   * This method has been deprecated, please use method buildTaskRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public TaskRef getTaskRef() {
    return this.taskRef!=null ?this.taskRef.build():null;
  }
  public TaskRef buildTaskRef() {
    return this.taskRef!=null ?this.taskRef.build():null;
  }
  public A withTaskRef(TaskRef taskRef) {
    _visitables.get("taskRef").remove(this.taskRef);
    if (taskRef!=null){ this.taskRef= new TaskRefBuilder(taskRef); _visitables.get("taskRef").add(this.taskRef);} else { this.taskRef = null; _visitables.get("taskRef").remove(this.taskRef); } return (A) this;
  }
  public Boolean hasTaskRef() {
    return this.taskRef != null;
  }
  public TaskRunSpecFluentImpl.TaskRefNested<A> withNewTaskRef() {
    return new TaskRunSpecFluentImpl.TaskRefNestedImpl();
  }
  public TaskRunSpecFluentImpl.TaskRefNested<A> withNewTaskRefLike(TaskRef item) {
    return new TaskRunSpecFluentImpl.TaskRefNestedImpl(item);
  }
  public TaskRunSpecFluentImpl.TaskRefNested<A> editTaskRef() {
    return withNewTaskRefLike(getTaskRef());
  }
  public TaskRunSpecFluentImpl.TaskRefNested<A> editOrNewTaskRef() {
    return withNewTaskRefLike(getTaskRef() != null ? getTaskRef(): new TaskRefBuilder().build());
  }
  public TaskRunSpecFluentImpl.TaskRefNested<A> editOrNewTaskRefLike(TaskRef item) {
    return withNewTaskRefLike(getTaskRef() != null ? getTaskRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTaskSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public TaskSpec getTaskSpec() {
    return this.taskSpec!=null ?this.taskSpec.build():null;
  }
  public TaskSpec buildTaskSpec() {
    return this.taskSpec!=null ?this.taskSpec.build():null;
  }
  public A withTaskSpec(TaskSpec taskSpec) {
    _visitables.get("taskSpec").remove(this.taskSpec);
    if (taskSpec!=null){ this.taskSpec= new TaskSpecBuilder(taskSpec); _visitables.get("taskSpec").add(this.taskSpec);} else { this.taskSpec = null; _visitables.get("taskSpec").remove(this.taskSpec); } return (A) this;
  }
  public Boolean hasTaskSpec() {
    return this.taskSpec != null;
  }
  public TaskRunSpecFluentImpl.TaskSpecNested<A> withNewTaskSpec() {
    return new TaskRunSpecFluentImpl.TaskSpecNestedImpl();
  }
  public TaskRunSpecFluentImpl.TaskSpecNested<A> withNewTaskSpecLike(TaskSpec item) {
    return new TaskRunSpecFluentImpl.TaskSpecNestedImpl(item);
  }
  public TaskRunSpecFluentImpl.TaskSpecNested<A> editTaskSpec() {
    return withNewTaskSpecLike(getTaskSpec());
  }
  public TaskRunSpecFluentImpl.TaskSpecNested<A> editOrNewTaskSpec() {
    return withNewTaskSpecLike(getTaskSpec() != null ? getTaskSpec(): new TaskSpecBuilder().build());
  }
  public TaskRunSpecFluentImpl.TaskSpecNested<A> editOrNewTaskSpecLike(TaskSpec item) {
    return withNewTaskSpecLike(getTaskSpec() != null ? getTaskSpec(): item);
  }
  public Duration getTimeout() {
    return this.timeout;
  }
  public A withTimeout(Duration timeout) {
    this.timeout=timeout; return (A) this;
  }
  public Boolean hasTimeout() {
    return this.timeout != null;
  }
  public A addToWorkspaces(int index,WorkspaceBinding item) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
    if (index < 0 || index >= workspaces.size()) { _visitables.get("workspaces").add(builder); workspaces.add(builder); } else { _visitables.get("workspaces").add(index, builder); workspaces.add(index, builder);}
    return (A)this;
  }
  public A setToWorkspaces(int index,WorkspaceBinding item) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
    if (index < 0 || index >= workspaces.size()) { _visitables.get("workspaces").add(builder); workspaces.add(builder); } else { _visitables.get("workspaces").set(index, builder); workspaces.set(index, builder);}
    return (A)this;
  }
  public A addToWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspaceBinding... items) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").add(builder);this.workspaces.add(builder);} return (A)this;
  }
  public A addAllToWorkspaces(Collection<WorkspaceBinding> items) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").add(builder);this.workspaces.add(builder);} return (A)this;
  }
  public A removeFromWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspaceBinding... items) {
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").remove(builder);if (this.workspaces != null) {this.workspaces.remove(builder);}} return (A)this;
  }
  public A removeAllFromWorkspaces(Collection<WorkspaceBinding> items) {
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").remove(builder);if (this.workspaces != null) {this.workspaces.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromWorkspaces(Predicate<WorkspaceBindingBuilder> predicate) {
    if (workspaces == null) return (A) this;
    final Iterator<WorkspaceBindingBuilder> each = workspaces.iterator();
    final List visitables = _visitables.get("workspaces");
    while (each.hasNext()) {
      WorkspaceBindingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildWorkspaces instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<WorkspaceBinding> getWorkspaces() {
    return workspaces != null ? build(workspaces) : null;
  }
  public List<WorkspaceBinding> buildWorkspaces() {
    return workspaces != null ? build(workspaces) : null;
  }
  public WorkspaceBinding buildWorkspace(int index) {
    return this.workspaces.get(index).build();
  }
  public WorkspaceBinding buildFirstWorkspace() {
    return this.workspaces.get(0).build();
  }
  public WorkspaceBinding buildLastWorkspace() {
    return this.workspaces.get(workspaces.size() - 1).build();
  }
  public WorkspaceBinding buildMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
    for (WorkspaceBindingBuilder item: workspaces) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
    for (WorkspaceBindingBuilder item: workspaces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withWorkspaces(List<WorkspaceBinding> workspaces) {
    if (this.workspaces != null) { _visitables.get("workspaces").clear();}
    if (workspaces != null) {this.workspaces = new ArrayList(); for (WorkspaceBinding item : workspaces){this.addToWorkspaces(item);}} else { this.workspaces = null;} return (A) this;
  }
  public A withWorkspaces(io.fabric8.tekton.pipeline.v1.WorkspaceBinding... workspaces) {
    if (this.workspaces != null) {this.workspaces.clear(); _visitables.remove("workspaces"); }
    if (workspaces != null) {for (WorkspaceBinding item :workspaces){ this.addToWorkspaces(item);}} return (A) this;
  }
  public Boolean hasWorkspaces() {
    return workspaces != null && !workspaces.isEmpty();
  }
  public TaskRunSpecFluentImpl.WorkspacesNested<A> addNewWorkspace() {
    return new TaskRunSpecFluentImpl.WorkspacesNestedImpl();
  }
  public TaskRunSpecFluentImpl.WorkspacesNested<A> addNewWorkspaceLike(WorkspaceBinding item) {
    return new TaskRunSpecFluentImpl.WorkspacesNestedImpl(-1, item);
  }
  public TaskRunSpecFluentImpl.WorkspacesNested<A> setNewWorkspaceLike(int index,WorkspaceBinding item) {
    return new TaskRunSpecFluentImpl.WorkspacesNestedImpl(index, item);
  }
  public TaskRunSpecFluentImpl.WorkspacesNested<A> editWorkspace(int index) {
    if (workspaces.size() <= index) throw new RuntimeException("Can't edit workspaces. Index exceeds size.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  public TaskRunSpecFluentImpl.WorkspacesNested<A> editFirstWorkspace() {
    if (workspaces.size() == 0) throw new RuntimeException("Can't edit first workspaces. The list is empty.");
    return setNewWorkspaceLike(0, buildWorkspace(0));
  }
  public TaskRunSpecFluentImpl.WorkspacesNested<A> editLastWorkspace() {
    int index = workspaces.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last workspaces. The list is empty.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  public TaskRunSpecFluentImpl.WorkspacesNested<A> editMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<workspaces.size();i++) { 
    if (predicate.test(workspaces.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching workspaces. No match found.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TaskRunSpecFluentImpl that = (TaskRunSpecFluentImpl) o;
    if (!java.util.Objects.equals(computeResources, that.computeResources)) return false;

    if (!java.util.Objects.equals(debug, that.debug)) return false;

    if (!java.util.Objects.equals(params, that.params)) return false;

    if (!java.util.Objects.equals(podTemplate, that.podTemplate)) return false;

    if (!java.util.Objects.equals(retries, that.retries)) return false;

    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;

    if (!java.util.Objects.equals(sidecarSpecs, that.sidecarSpecs)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    if (!java.util.Objects.equals(statusMessage, that.statusMessage)) return false;

    if (!java.util.Objects.equals(stepSpecs, that.stepSpecs)) return false;

    if (!java.util.Objects.equals(taskRef, that.taskRef)) return false;

    if (!java.util.Objects.equals(taskSpec, that.taskSpec)) return false;

    if (!java.util.Objects.equals(timeout, that.timeout)) return false;

    if (!java.util.Objects.equals(workspaces, that.workspaces)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(computeResources,  debug,  params,  podTemplate,  retries,  serviceAccountName,  sidecarSpecs,  status,  statusMessage,  stepSpecs,  taskRef,  taskSpec,  timeout,  workspaces,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (computeResources != null) { sb.append("computeResources:"); sb.append(computeResources + ","); }
    if (debug != null) { sb.append("debug:"); sb.append(debug + ","); }
    if (params != null) { sb.append("params:"); sb.append(params + ","); }
    if (podTemplate != null) { sb.append("podTemplate:"); sb.append(podTemplate + ","); }
    if (retries != null) { sb.append("retries:"); sb.append(retries + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (sidecarSpecs != null) { sb.append("sidecarSpecs:"); sb.append(sidecarSpecs + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (statusMessage != null) { sb.append("statusMessage:"); sb.append(statusMessage + ","); }
    if (stepSpecs != null) { sb.append("stepSpecs:"); sb.append(stepSpecs + ","); }
    if (taskRef != null) { sb.append("taskRef:"); sb.append(taskRef + ","); }
    if (taskSpec != null) { sb.append("taskSpec:"); sb.append(taskSpec + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout + ","); }
    if (workspaces != null) { sb.append("workspaces:"); sb.append(workspaces); }
    sb.append("}");
    return sb.toString();
  }
  class ComputeResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<TaskRunSpecFluentImpl.ComputeResourcesNested<N>> implements TaskRunSpecFluentImpl.ComputeResourcesNested<N>,Nested<N>{
    ComputeResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ComputeResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) TaskRunSpecFluentImpl.this.withComputeResources(builder.build());
    }
    public N endComputeResources() {
      return and();
    }
    
  }
  class DebugNestedImpl<N> extends TaskRunDebugFluentImpl<TaskRunSpecFluentImpl.DebugNested<N>> implements TaskRunSpecFluentImpl.DebugNested<N>,Nested<N>{
    DebugNestedImpl(TaskRunDebug item) {
      this.builder = new TaskRunDebugBuilder(this, item);
    }
    DebugNestedImpl() {
      this.builder = new TaskRunDebugBuilder(this);
    }
    TaskRunDebugBuilder builder;
    public N and() {
      return (N) TaskRunSpecFluentImpl.this.withDebug(builder.build());
    }
    public N endDebug() {
      return and();
    }
    
  }
  class ParamsNestedImpl<N> extends ParamFluentImpl<TaskRunSpecFluentImpl.ParamsNested<N>> implements TaskRunSpecFluentImpl.ParamsNested<N>,Nested<N>{
    ParamsNestedImpl(int index,Param item) {
      this.index = index;
      this.builder = new ParamBuilder(this, item);
    }
    ParamsNestedImpl() {
      this.index = -1;
      this.builder = new ParamBuilder(this);
    }
    ParamBuilder builder;
    int index;
    public N and() {
      return (N) TaskRunSpecFluentImpl.this.setToParams(index,builder.build());
    }
    public N endParam() {
      return and();
    }
    
  }
  class PodTemplateNestedImpl<N> extends TemplateFluentImpl<TaskRunSpecFluentImpl.PodTemplateNested<N>> implements TaskRunSpecFluentImpl.PodTemplateNested<N>,Nested<N>{
    PodTemplateNestedImpl(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    PodTemplateNestedImpl() {
      this.builder = new TemplateBuilder(this);
    }
    TemplateBuilder builder;
    public N and() {
      return (N) TaskRunSpecFluentImpl.this.withPodTemplate(builder.build());
    }
    public N endPodTemplate() {
      return and();
    }
    
  }
  class SidecarSpecsNestedImpl<N> extends TaskRunSidecarSpecFluentImpl<TaskRunSpecFluentImpl.SidecarSpecsNested<N>> implements TaskRunSpecFluentImpl.SidecarSpecsNested<N>,Nested<N>{
    SidecarSpecsNestedImpl(int index,TaskRunSidecarSpec item) {
      this.index = index;
      this.builder = new TaskRunSidecarSpecBuilder(this, item);
    }
    SidecarSpecsNestedImpl() {
      this.index = -1;
      this.builder = new TaskRunSidecarSpecBuilder(this);
    }
    TaskRunSidecarSpecBuilder builder;
    int index;
    public N and() {
      return (N) TaskRunSpecFluentImpl.this.setToSidecarSpecs(index,builder.build());
    }
    public N endSidecarSpec() {
      return and();
    }
    
  }
  class StepSpecsNestedImpl<N> extends TaskRunStepSpecFluentImpl<TaskRunSpecFluentImpl.StepSpecsNested<N>> implements TaskRunSpecFluentImpl.StepSpecsNested<N>,Nested<N>{
    StepSpecsNestedImpl(int index,TaskRunStepSpec item) {
      this.index = index;
      this.builder = new TaskRunStepSpecBuilder(this, item);
    }
    StepSpecsNestedImpl() {
      this.index = -1;
      this.builder = new TaskRunStepSpecBuilder(this);
    }
    TaskRunStepSpecBuilder builder;
    int index;
    public N and() {
      return (N) TaskRunSpecFluentImpl.this.setToStepSpecs(index,builder.build());
    }
    public N endStepSpec() {
      return and();
    }
    
  }
  class TaskRefNestedImpl<N> extends TaskRefFluentImpl<TaskRunSpecFluentImpl.TaskRefNested<N>> implements TaskRunSpecFluentImpl.TaskRefNested<N>,Nested<N>{
    TaskRefNestedImpl(TaskRef item) {
      this.builder = new TaskRefBuilder(this, item);
    }
    TaskRefNestedImpl() {
      this.builder = new TaskRefBuilder(this);
    }
    TaskRefBuilder builder;
    public N and() {
      return (N) TaskRunSpecFluentImpl.this.withTaskRef(builder.build());
    }
    public N endTaskRef() {
      return and();
    }
    
  }
  class TaskSpecNestedImpl<N> extends TaskSpecFluentImpl<TaskRunSpecFluentImpl.TaskSpecNested<N>> implements TaskRunSpecFluentImpl.TaskSpecNested<N>,Nested<N>{
    TaskSpecNestedImpl(TaskSpec item) {
      this.builder = new TaskSpecBuilder(this, item);
    }
    TaskSpecNestedImpl() {
      this.builder = new TaskSpecBuilder(this);
    }
    TaskSpecBuilder builder;
    public N and() {
      return (N) TaskRunSpecFluentImpl.this.withTaskSpec(builder.build());
    }
    public N endTaskSpec() {
      return and();
    }
    
  }
  class WorkspacesNestedImpl<N> extends WorkspaceBindingFluentImpl<TaskRunSpecFluentImpl.WorkspacesNested<N>> implements TaskRunSpecFluentImpl.WorkspacesNested<N>,Nested<N>{
    WorkspacesNestedImpl(int index,WorkspaceBinding item) {
      this.index = index;
      this.builder = new WorkspaceBindingBuilder(this, item);
    }
    WorkspacesNestedImpl() {
      this.index = -1;
      this.builder = new WorkspaceBindingBuilder(this);
    }
    WorkspaceBindingBuilder builder;
    int index;
    public N and() {
      return (N) TaskRunSpecFluentImpl.this.setToWorkspaces(index,builder.build());
    }
    public N endWorkspace() {
      return and();
    }
    
  }
  
}