package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskRunSidecarSpecBuilder extends TaskRunSidecarSpecFluentImpl<TaskRunSidecarSpecBuilder> implements VisitableBuilder<TaskRunSidecarSpec,TaskRunSidecarSpecBuilder>{
  public TaskRunSidecarSpecBuilder() {
    this(false);
  }
  public TaskRunSidecarSpecBuilder(Boolean validationEnabled) {
    this(new TaskRunSidecarSpec(), validationEnabled);
  }
  public TaskRunSidecarSpecBuilder(TaskRunSidecarSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskRunSidecarSpecBuilder(TaskRunSidecarSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TaskRunSidecarSpec(), validationEnabled);
  }
  public TaskRunSidecarSpecBuilder(TaskRunSidecarSpecFluent<?> fluent,TaskRunSidecarSpec instance) {
    this(fluent, instance, false);
  }
  public TaskRunSidecarSpecBuilder(TaskRunSidecarSpecFluent<?> fluent,TaskRunSidecarSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withComputeResources(instance.getComputeResources());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaskRunSidecarSpecBuilder(TaskRunSidecarSpec instance) {
    this(instance,false);
  }
  public TaskRunSidecarSpecBuilder(TaskRunSidecarSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withComputeResources(instance.getComputeResources());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaskRunSidecarSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TaskRunSidecarSpec build() {
    TaskRunSidecarSpec buildable = new TaskRunSidecarSpec(fluent.getComputeResources(),fluent.getName());
    return buildable;
  }
  
}