package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskRunResultBuilder extends TaskRunResultFluentImpl<TaskRunResultBuilder> implements VisitableBuilder<TaskRunResult,TaskRunResultBuilder>{
  public TaskRunResultBuilder() {
    this(false);
  }
  public TaskRunResultBuilder(Boolean validationEnabled) {
    this(new TaskRunResult(), validationEnabled);
  }
  public TaskRunResultBuilder(TaskRunResultFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskRunResultBuilder(TaskRunResultFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TaskRunResult(), validationEnabled);
  }
  public TaskRunResultBuilder(TaskRunResultFluent<?> fluent,TaskRunResult instance) {
    this(fluent, instance, false);
  }
  public TaskRunResultBuilder(TaskRunResultFluent<?> fluent,TaskRunResult instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withType(instance.getType());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaskRunResultBuilder(TaskRunResult instance) {
    this(instance,false);
  }
  public TaskRunResultBuilder(TaskRunResult instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withType(instance.getType());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaskRunResultFluent<?> fluent;
  Boolean validationEnabled;
  public TaskRunResult build() {
    TaskRunResult buildable = new TaskRunResult(fluent.getName(),fluent.getType(),fluent.getValue());
    return buildable;
  }
  
}