package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskRunListBuilder extends TaskRunListFluentImpl<TaskRunListBuilder> implements VisitableBuilder<TaskRunList,TaskRunListBuilder>{
  public TaskRunListBuilder() {
    this(false);
  }
  public TaskRunListBuilder(Boolean validationEnabled) {
    this(new TaskRunList(), validationEnabled);
  }
  public TaskRunListBuilder(TaskRunListFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskRunListBuilder(TaskRunListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TaskRunList(), validationEnabled);
  }
  public TaskRunListBuilder(TaskRunListFluent<?> fluent,TaskRunList instance) {
    this(fluent, instance, false);
  }
  public TaskRunListBuilder(TaskRunListFluent<?> fluent,TaskRunList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaskRunListBuilder(TaskRunList instance) {
    this(instance,false);
  }
  public TaskRunListBuilder(TaskRunList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaskRunListFluent<?> fluent;
  Boolean validationEnabled;
  public TaskRunList build() {
    TaskRunList buildable = new TaskRunList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}