package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskRunDebugBuilder extends TaskRunDebugFluentImpl<TaskRunDebugBuilder> implements VisitableBuilder<TaskRunDebug,TaskRunDebugBuilder>{
  public TaskRunDebugBuilder() {
    this(false);
  }
  public TaskRunDebugBuilder(Boolean validationEnabled) {
    this(new TaskRunDebug(), validationEnabled);
  }
  public TaskRunDebugBuilder(TaskRunDebugFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskRunDebugBuilder(TaskRunDebugFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TaskRunDebug(), validationEnabled);
  }
  public TaskRunDebugBuilder(TaskRunDebugFluent<?> fluent,TaskRunDebug instance) {
    this(fluent, instance, false);
  }
  public TaskRunDebugBuilder(TaskRunDebugFluent<?> fluent,TaskRunDebug instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBreakpoint(instance.getBreakpoint());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaskRunDebugBuilder(TaskRunDebug instance) {
    this(instance,false);
  }
  public TaskRunDebugBuilder(TaskRunDebug instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBreakpoint(instance.getBreakpoint());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaskRunDebugFluent<?> fluent;
  Boolean validationEnabled;
  public TaskRunDebug build() {
    TaskRunDebug buildable = new TaskRunDebug(fluent.getBreakpoint());
    return buildable;
  }
  
}