package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TaskResultBuilder extends TaskResultFluentImpl<TaskResultBuilder> implements VisitableBuilder<TaskResult,TaskResultBuilder>{
  public TaskResultBuilder() {
    this(false);
  }
  public TaskResultBuilder(Boolean validationEnabled) {
    this(new TaskResult(), validationEnabled);
  }
  public TaskResultBuilder(TaskResultFluent<?> fluent) {
    this(fluent, false);
  }
  public TaskResultBuilder(TaskResultFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TaskResult(), validationEnabled);
  }
  public TaskResultBuilder(TaskResultFluent<?> fluent,TaskResult instance) {
    this(fluent, instance, false);
  }
  public TaskResultBuilder(TaskResultFluent<?> fluent,TaskResult instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withName(instance.getName());
      fluent.withProperties(instance.getProperties());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TaskResultBuilder(TaskResult instance) {
    this(instance,false);
  }
  public TaskResultBuilder(TaskResult instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withName(instance.getName());
      this.withProperties(instance.getProperties());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  TaskResultFluent<?> fluent;
  Boolean validationEnabled;
  public TaskResult build() {
    TaskResult buildable = new TaskResult(fluent.getDescription(),fluent.getName(),fluent.getProperties(),fluent.getType());
    return buildable;
  }
  
}