package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StepTemplateBuilder extends StepTemplateFluentImpl<StepTemplateBuilder> implements VisitableBuilder<StepTemplate,StepTemplateBuilder>{
  public StepTemplateBuilder() {
    this(false);
  }
  public StepTemplateBuilder(Boolean validationEnabled) {
    this(new StepTemplate(), validationEnabled);
  }
  public StepTemplateBuilder(StepTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public StepTemplateBuilder(StepTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StepTemplate(), validationEnabled);
  }
  public StepTemplateBuilder(StepTemplateFluent<?> fluent,StepTemplate instance) {
    this(fluent, instance, false);
  }
  public StepTemplateBuilder(StepTemplateFluent<?> fluent,StepTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withArgs(instance.getArgs());
      fluent.withCommand(instance.getCommand());
      fluent.withComputeResources(instance.getComputeResources());
      fluent.withEnv(instance.getEnv());
      fluent.withEnvFrom(instance.getEnvFrom());
      fluent.withImage(instance.getImage());
      fluent.withImagePullPolicy(instance.getImagePullPolicy());
      fluent.withSecurityContext(instance.getSecurityContext());
      fluent.withVolumeDevices(instance.getVolumeDevices());
      fluent.withVolumeMounts(instance.getVolumeMounts());
      fluent.withWorkingDir(instance.getWorkingDir());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StepTemplateBuilder(StepTemplate instance) {
    this(instance,false);
  }
  public StepTemplateBuilder(StepTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withArgs(instance.getArgs());
      this.withCommand(instance.getCommand());
      this.withComputeResources(instance.getComputeResources());
      this.withEnv(instance.getEnv());
      this.withEnvFrom(instance.getEnvFrom());
      this.withImage(instance.getImage());
      this.withImagePullPolicy(instance.getImagePullPolicy());
      this.withSecurityContext(instance.getSecurityContext());
      this.withVolumeDevices(instance.getVolumeDevices());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withWorkingDir(instance.getWorkingDir());
    }
    this.validationEnabled = validationEnabled; 
  }
  StepTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public StepTemplate build() {
    StepTemplate buildable = new StepTemplate(fluent.getArgs(),fluent.getCommand(),fluent.getComputeResources(),fluent.getEnv(),fluent.getEnvFrom(),fluent.getImage(),fluent.getImagePullPolicy(),fluent.getSecurityContext(),fluent.getVolumeDevices(),fluent.getVolumeMounts(),fluent.getWorkingDir());
    return buildable;
  }
  
}