package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StepOutputConfigBuilder extends StepOutputConfigFluentImpl<StepOutputConfigBuilder> implements VisitableBuilder<StepOutputConfig,StepOutputConfigBuilder>{
  public StepOutputConfigBuilder() {
    this(false);
  }
  public StepOutputConfigBuilder(Boolean validationEnabled) {
    this(new StepOutputConfig(), validationEnabled);
  }
  public StepOutputConfigBuilder(StepOutputConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public StepOutputConfigBuilder(StepOutputConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StepOutputConfig(), validationEnabled);
  }
  public StepOutputConfigBuilder(StepOutputConfigFluent<?> fluent,StepOutputConfig instance) {
    this(fluent, instance, false);
  }
  public StepOutputConfigBuilder(StepOutputConfigFluent<?> fluent,StepOutputConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPath(instance.getPath());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StepOutputConfigBuilder(StepOutputConfig instance) {
    this(instance,false);
  }
  public StepOutputConfigBuilder(StepOutputConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPath(instance.getPath());
    }
    this.validationEnabled = validationEnabled; 
  }
  StepOutputConfigFluent<?> fluent;
  Boolean validationEnabled;
  public StepOutputConfig build() {
    StepOutputConfig buildable = new StepOutputConfig(fluent.getPath());
    return buildable;
  }
  
}