package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SkippedTaskBuilder extends SkippedTaskFluentImpl<SkippedTaskBuilder> implements VisitableBuilder<SkippedTask,SkippedTaskBuilder>{
  public SkippedTaskBuilder() {
    this(false);
  }
  public SkippedTaskBuilder(Boolean validationEnabled) {
    this(new SkippedTask(), validationEnabled);
  }
  public SkippedTaskBuilder(SkippedTaskFluent<?> fluent) {
    this(fluent, false);
  }
  public SkippedTaskBuilder(SkippedTaskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SkippedTask(), validationEnabled);
  }
  public SkippedTaskBuilder(SkippedTaskFluent<?> fluent,SkippedTask instance) {
    this(fluent, instance, false);
  }
  public SkippedTaskBuilder(SkippedTaskFluent<?> fluent,SkippedTask instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withReason(instance.getReason());
      fluent.withWhenExpressions(instance.getWhenExpressions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SkippedTaskBuilder(SkippedTask instance) {
    this(instance,false);
  }
  public SkippedTaskBuilder(SkippedTask instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withReason(instance.getReason());
      this.withWhenExpressions(instance.getWhenExpressions());
    }
    this.validationEnabled = validationEnabled; 
  }
  SkippedTaskFluent<?> fluent;
  Boolean validationEnabled;
  public SkippedTask build() {
    SkippedTask buildable = new SkippedTask(fluent.getName(),fluent.getReason(),fluent.getWhenExpressions());
    return buildable;
  }
  
}