package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SidecarStateBuilder extends SidecarStateFluentImpl<SidecarStateBuilder> implements VisitableBuilder<SidecarState,SidecarStateBuilder>{
  public SidecarStateBuilder() {
    this(false);
  }
  public SidecarStateBuilder(Boolean validationEnabled) {
    this(new SidecarState(), validationEnabled);
  }
  public SidecarStateBuilder(SidecarStateFluent<?> fluent) {
    this(fluent, false);
  }
  public SidecarStateBuilder(SidecarStateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SidecarState(), validationEnabled);
  }
  public SidecarStateBuilder(SidecarStateFluent<?> fluent,SidecarState instance) {
    this(fluent, instance, false);
  }
  public SidecarStateBuilder(SidecarStateFluent<?> fluent,SidecarState instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withContainer(instance.getContainer());
      fluent.withImageID(instance.getImageID());
      fluent.withName(instance.getName());
      fluent.withRunning(instance.getRunning());
      fluent.withTerminated(instance.getTerminated());
      fluent.withWaiting(instance.getWaiting());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SidecarStateBuilder(SidecarState instance) {
    this(instance,false);
  }
  public SidecarStateBuilder(SidecarState instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withContainer(instance.getContainer());
      this.withImageID(instance.getImageID());
      this.withName(instance.getName());
      this.withRunning(instance.getRunning());
      this.withTerminated(instance.getTerminated());
      this.withWaiting(instance.getWaiting());
    }
    this.validationEnabled = validationEnabled; 
  }
  SidecarStateFluent<?> fluent;
  Boolean validationEnabled;
  public SidecarState build() {
    SidecarState buildable = new SidecarState(fluent.getContainer(),fluent.getImageID(),fluent.getName(),fluent.getRunning(),fluent.getTerminated(),fluent.getWaiting());
    return buildable;
  }
  
}