package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SidecarBuilder extends SidecarFluentImpl<SidecarBuilder> implements VisitableBuilder<Sidecar,SidecarBuilder>{
  public SidecarBuilder() {
    this(false);
  }
  public SidecarBuilder(Boolean validationEnabled) {
    this(new Sidecar(), validationEnabled);
  }
  public SidecarBuilder(SidecarFluent<?> fluent) {
    this(fluent, false);
  }
  public SidecarBuilder(SidecarFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Sidecar(), validationEnabled);
  }
  public SidecarBuilder(SidecarFluent<?> fluent,Sidecar instance) {
    this(fluent, instance, false);
  }
  public SidecarBuilder(SidecarFluent<?> fluent,Sidecar instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withArgs(instance.getArgs());
      fluent.withCommand(instance.getCommand());
      fluent.withComputeResources(instance.getComputeResources());
      fluent.withEnv(instance.getEnv());
      fluent.withEnvFrom(instance.getEnvFrom());
      fluent.withImage(instance.getImage());
      fluent.withImagePullPolicy(instance.getImagePullPolicy());
      fluent.withLifecycle(instance.getLifecycle());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withName(instance.getName());
      fluent.withPorts(instance.getPorts());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withScript(instance.getScript());
      fluent.withSecurityContext(instance.getSecurityContext());
      fluent.withStartupProbe(instance.getStartupProbe());
      fluent.withStdin(instance.getStdin());
      fluent.withStdinOnce(instance.getStdinOnce());
      fluent.withTerminationMessagePath(instance.getTerminationMessagePath());
      fluent.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
      fluent.withTty(instance.getTty());
      fluent.withVolumeDevices(instance.getVolumeDevices());
      fluent.withVolumeMounts(instance.getVolumeMounts());
      fluent.withWorkingDir(instance.getWorkingDir());
      fluent.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SidecarBuilder(Sidecar instance) {
    this(instance,false);
  }
  public SidecarBuilder(Sidecar instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withArgs(instance.getArgs());
      this.withCommand(instance.getCommand());
      this.withComputeResources(instance.getComputeResources());
      this.withEnv(instance.getEnv());
      this.withEnvFrom(instance.getEnvFrom());
      this.withImage(instance.getImage());
      this.withImagePullPolicy(instance.getImagePullPolicy());
      this.withLifecycle(instance.getLifecycle());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withName(instance.getName());
      this.withPorts(instance.getPorts());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withScript(instance.getScript());
      this.withSecurityContext(instance.getSecurityContext());
      this.withStartupProbe(instance.getStartupProbe());
      this.withStdin(instance.getStdin());
      this.withStdinOnce(instance.getStdinOnce());
      this.withTerminationMessagePath(instance.getTerminationMessagePath());
      this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
      this.withTty(instance.getTty());
      this.withVolumeDevices(instance.getVolumeDevices());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withWorkingDir(instance.getWorkingDir());
      this.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  SidecarFluent<?> fluent;
  Boolean validationEnabled;
  public Sidecar build() {
    Sidecar buildable = new Sidecar(fluent.getArgs(),fluent.getCommand(),fluent.getComputeResources(),fluent.getEnv(),fluent.getEnvFrom(),fluent.getImage(),fluent.getImagePullPolicy(),fluent.getLifecycle(),fluent.getLivenessProbe(),fluent.getName(),fluent.getPorts(),fluent.getReadinessProbe(),fluent.getScript(),fluent.getSecurityContext(),fluent.getStartupProbe(),fluent.getStdin(),fluent.getStdinOnce(),fluent.getTerminationMessagePath(),fluent.getTerminationMessagePolicy(),fluent.getTty(),fluent.getVolumeDevices(),fluent.getVolumeMounts(),fluent.getWorkingDir(),fluent.getWorkspaces());
    return buildable;
  }
  
}