package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.tekton.v1.internal.pipeline.pkg.apis.pipeline.pod.TemplateBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.tekton.v1.internal.pipeline.pkg.apis.pipeline.pod.Template;
import io.fabric8.tekton.v1.internal.pipeline.pkg.apis.pipeline.pod.TemplateFluentImpl;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PipelineTaskRunSpecFluentImpl<A extends PipelineTaskRunSpecFluent<A>> extends BaseFluent<A> implements PipelineTaskRunSpecFluent<A>{
  public PipelineTaskRunSpecFluentImpl() {
  }
  public PipelineTaskRunSpecFluentImpl(PipelineTaskRunSpec instance) {
    if (instance != null) {
      this.withComputeResources(instance.getComputeResources());
      this.withMetadata(instance.getMetadata());
      this.withPipelineTaskName(instance.getPipelineTaskName());
      this.withPodTemplate(instance.getPodTemplate());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSidecarSpecs(instance.getSidecarSpecs());
      this.withStepSpecs(instance.getStepSpecs());
    }
  }
  private ResourceRequirementsBuilder computeResources;
  private PipelineTaskMetadataBuilder metadata;
  private String pipelineTaskName;
  private TemplateBuilder podTemplate;
  private String serviceAccountName;
  private ArrayList<TaskRunSidecarSpecBuilder> sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();
  private ArrayList<TaskRunStepSpecBuilder> stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();
  
  /**
   * This method has been deprecated, please use method buildComputeResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getComputeResources() {
    return this.computeResources!=null ?this.computeResources.build():null;
  }
  public ResourceRequirements buildComputeResources() {
    return this.computeResources!=null ?this.computeResources.build():null;
  }
  public A withComputeResources(ResourceRequirements computeResources) {
    _visitables.get("computeResources").remove(this.computeResources);
    if (computeResources!=null){ this.computeResources= new ResourceRequirementsBuilder(computeResources); _visitables.get("computeResources").add(this.computeResources);} else { this.computeResources = null; _visitables.get("computeResources").remove(this.computeResources); } return (A) this;
  }
  public Boolean hasComputeResources() {
    return this.computeResources != null;
  }
  public PipelineTaskRunSpecFluentImpl.ComputeResourcesNested<A> withNewComputeResources() {
    return new PipelineTaskRunSpecFluentImpl.ComputeResourcesNestedImpl();
  }
  public PipelineTaskRunSpecFluentImpl.ComputeResourcesNested<A> withNewComputeResourcesLike(ResourceRequirements item) {
    return new PipelineTaskRunSpecFluentImpl.ComputeResourcesNestedImpl(item);
  }
  public PipelineTaskRunSpecFluentImpl.ComputeResourcesNested<A> editComputeResources() {
    return withNewComputeResourcesLike(getComputeResources());
  }
  public PipelineTaskRunSpecFluentImpl.ComputeResourcesNested<A> editOrNewComputeResources() {
    return withNewComputeResourcesLike(getComputeResources() != null ? getComputeResources(): new ResourceRequirementsBuilder().build());
  }
  public PipelineTaskRunSpecFluentImpl.ComputeResourcesNested<A> editOrNewComputeResourcesLike(ResourceRequirements item) {
    return withNewComputeResourcesLike(getComputeResources() != null ? getComputeResources(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public PipelineTaskMetadata getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public PipelineTaskMetadata buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(PipelineTaskMetadata metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new PipelineTaskMetadataBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public PipelineTaskRunSpecFluentImpl.MetadataNested<A> withNewMetadata() {
    return new PipelineTaskRunSpecFluentImpl.MetadataNestedImpl();
  }
  public PipelineTaskRunSpecFluentImpl.MetadataNested<A> withNewMetadataLike(PipelineTaskMetadata item) {
    return new PipelineTaskRunSpecFluentImpl.MetadataNestedImpl(item);
  }
  public PipelineTaskRunSpecFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public PipelineTaskRunSpecFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new PipelineTaskMetadataBuilder().build());
  }
  public PipelineTaskRunSpecFluentImpl.MetadataNested<A> editOrNewMetadataLike(PipelineTaskMetadata item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public String getPipelineTaskName() {
    return this.pipelineTaskName;
  }
  public A withPipelineTaskName(String pipelineTaskName) {
    this.pipelineTaskName=pipelineTaskName; return (A) this;
  }
  public Boolean hasPipelineTaskName() {
    return this.pipelineTaskName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPodTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public Template getPodTemplate() {
    return this.podTemplate!=null ?this.podTemplate.build():null;
  }
  public Template buildPodTemplate() {
    return this.podTemplate!=null ?this.podTemplate.build():null;
  }
  public A withPodTemplate(Template podTemplate) {
    _visitables.get("podTemplate").remove(this.podTemplate);
    if (podTemplate!=null){ this.podTemplate= new TemplateBuilder(podTemplate); _visitables.get("podTemplate").add(this.podTemplate);} else { this.podTemplate = null; _visitables.get("podTemplate").remove(this.podTemplate); } return (A) this;
  }
  public Boolean hasPodTemplate() {
    return this.podTemplate != null;
  }
  public PipelineTaskRunSpecFluentImpl.PodTemplateNested<A> withNewPodTemplate() {
    return new PipelineTaskRunSpecFluentImpl.PodTemplateNestedImpl();
  }
  public PipelineTaskRunSpecFluentImpl.PodTemplateNested<A> withNewPodTemplateLike(Template item) {
    return new PipelineTaskRunSpecFluentImpl.PodTemplateNestedImpl(item);
  }
  public PipelineTaskRunSpecFluentImpl.PodTemplateNested<A> editPodTemplate() {
    return withNewPodTemplateLike(getPodTemplate());
  }
  public PipelineTaskRunSpecFluentImpl.PodTemplateNested<A> editOrNewPodTemplate() {
    return withNewPodTemplateLike(getPodTemplate() != null ? getPodTemplate(): new TemplateBuilder().build());
  }
  public PipelineTaskRunSpecFluentImpl.PodTemplateNested<A> editOrNewPodTemplateLike(Template item) {
    return withNewPodTemplateLike(getPodTemplate() != null ? getPodTemplate(): item);
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  public A addToSidecarSpecs(int index,TaskRunSidecarSpec item) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
    if (index < 0 || index >= sidecarSpecs.size()) { _visitables.get("sidecarSpecs").add(builder); sidecarSpecs.add(builder); } else { _visitables.get("sidecarSpecs").add(index, builder); sidecarSpecs.add(index, builder);}
    return (A)this;
  }
  public A setToSidecarSpecs(int index,TaskRunSidecarSpec item) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
    if (index < 0 || index >= sidecarSpecs.size()) { _visitables.get("sidecarSpecs").add(builder); sidecarSpecs.add(builder); } else { _visitables.get("sidecarSpecs").set(index, builder); sidecarSpecs.set(index, builder);}
    return (A)this;
  }
  public A addToSidecarSpecs(io.fabric8.tekton.pipeline.v1.TaskRunSidecarSpec... items) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").add(builder);this.sidecarSpecs.add(builder);} return (A)this;
  }
  public A addAllToSidecarSpecs(Collection<TaskRunSidecarSpec> items) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").add(builder);this.sidecarSpecs.add(builder);} return (A)this;
  }
  public A removeFromSidecarSpecs(io.fabric8.tekton.pipeline.v1.TaskRunSidecarSpec... items) {
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").remove(builder);if (this.sidecarSpecs != null) {this.sidecarSpecs.remove(builder);}} return (A)this;
  }
  public A removeAllFromSidecarSpecs(Collection<TaskRunSidecarSpec> items) {
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").remove(builder);if (this.sidecarSpecs != null) {this.sidecarSpecs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSidecarSpecs(Predicate<TaskRunSidecarSpecBuilder> predicate) {
    if (sidecarSpecs == null) return (A) this;
    final Iterator<TaskRunSidecarSpecBuilder> each = sidecarSpecs.iterator();
    final List visitables = _visitables.get("sidecarSpecs");
    while (each.hasNext()) {
      TaskRunSidecarSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSidecarSpecs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TaskRunSidecarSpec> getSidecarSpecs() {
    return sidecarSpecs != null ? build(sidecarSpecs) : null;
  }
  public List<TaskRunSidecarSpec> buildSidecarSpecs() {
    return sidecarSpecs != null ? build(sidecarSpecs) : null;
  }
  public TaskRunSidecarSpec buildSidecarSpec(int index) {
    return this.sidecarSpecs.get(index).build();
  }
  public TaskRunSidecarSpec buildFirstSidecarSpec() {
    return this.sidecarSpecs.get(0).build();
  }
  public TaskRunSidecarSpec buildLastSidecarSpec() {
    return this.sidecarSpecs.get(sidecarSpecs.size() - 1).build();
  }
  public TaskRunSidecarSpec buildMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
    for (TaskRunSidecarSpecBuilder item: sidecarSpecs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
    for (TaskRunSidecarSpecBuilder item: sidecarSpecs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSidecarSpecs(List<TaskRunSidecarSpec> sidecarSpecs) {
    if (this.sidecarSpecs != null) { _visitables.get("sidecarSpecs").clear();}
    if (sidecarSpecs != null) {this.sidecarSpecs = new ArrayList(); for (TaskRunSidecarSpec item : sidecarSpecs){this.addToSidecarSpecs(item);}} else { this.sidecarSpecs = null;} return (A) this;
  }
  public A withSidecarSpecs(io.fabric8.tekton.pipeline.v1.TaskRunSidecarSpec... sidecarSpecs) {
    if (this.sidecarSpecs != null) {this.sidecarSpecs.clear(); _visitables.remove("sidecarSpecs"); }
    if (sidecarSpecs != null) {for (TaskRunSidecarSpec item :sidecarSpecs){ this.addToSidecarSpecs(item);}} return (A) this;
  }
  public Boolean hasSidecarSpecs() {
    return sidecarSpecs != null && !sidecarSpecs.isEmpty();
  }
  public PipelineTaskRunSpecFluentImpl.SidecarSpecsNested<A> addNewSidecarSpec() {
    return new PipelineTaskRunSpecFluentImpl.SidecarSpecsNestedImpl();
  }
  public PipelineTaskRunSpecFluentImpl.SidecarSpecsNested<A> addNewSidecarSpecLike(TaskRunSidecarSpec item) {
    return new PipelineTaskRunSpecFluentImpl.SidecarSpecsNestedImpl(-1, item);
  }
  public PipelineTaskRunSpecFluentImpl.SidecarSpecsNested<A> setNewSidecarSpecLike(int index,TaskRunSidecarSpec item) {
    return new PipelineTaskRunSpecFluentImpl.SidecarSpecsNestedImpl(index, item);
  }
  public PipelineTaskRunSpecFluentImpl.SidecarSpecsNested<A> editSidecarSpec(int index) {
    if (sidecarSpecs.size() <= index) throw new RuntimeException("Can't edit sidecarSpecs. Index exceeds size.");
    return setNewSidecarSpecLike(index, buildSidecarSpec(index));
  }
  public PipelineTaskRunSpecFluentImpl.SidecarSpecsNested<A> editFirstSidecarSpec() {
    if (sidecarSpecs.size() == 0) throw new RuntimeException("Can't edit first sidecarSpecs. The list is empty.");
    return setNewSidecarSpecLike(0, buildSidecarSpec(0));
  }
  public PipelineTaskRunSpecFluentImpl.SidecarSpecsNested<A> editLastSidecarSpec() {
    int index = sidecarSpecs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sidecarSpecs. The list is empty.");
    return setNewSidecarSpecLike(index, buildSidecarSpec(index));
  }
  public PipelineTaskRunSpecFluentImpl.SidecarSpecsNested<A> editMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sidecarSpecs.size();i++) { 
    if (predicate.test(sidecarSpecs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sidecarSpecs. No match found.");
    return setNewSidecarSpecLike(index, buildSidecarSpec(index));
  }
  public A addToStepSpecs(int index,TaskRunStepSpec item) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
    if (index < 0 || index >= stepSpecs.size()) { _visitables.get("stepSpecs").add(builder); stepSpecs.add(builder); } else { _visitables.get("stepSpecs").add(index, builder); stepSpecs.add(index, builder);}
    return (A)this;
  }
  public A setToStepSpecs(int index,TaskRunStepSpec item) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
    if (index < 0 || index >= stepSpecs.size()) { _visitables.get("stepSpecs").add(builder); stepSpecs.add(builder); } else { _visitables.get("stepSpecs").set(index, builder); stepSpecs.set(index, builder);}
    return (A)this;
  }
  public A addToStepSpecs(io.fabric8.tekton.pipeline.v1.TaskRunStepSpec... items) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").add(builder);this.stepSpecs.add(builder);} return (A)this;
  }
  public A addAllToStepSpecs(Collection<TaskRunStepSpec> items) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").add(builder);this.stepSpecs.add(builder);} return (A)this;
  }
  public A removeFromStepSpecs(io.fabric8.tekton.pipeline.v1.TaskRunStepSpec... items) {
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").remove(builder);if (this.stepSpecs != null) {this.stepSpecs.remove(builder);}} return (A)this;
  }
  public A removeAllFromStepSpecs(Collection<TaskRunStepSpec> items) {
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").remove(builder);if (this.stepSpecs != null) {this.stepSpecs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromStepSpecs(Predicate<TaskRunStepSpecBuilder> predicate) {
    if (stepSpecs == null) return (A) this;
    final Iterator<TaskRunStepSpecBuilder> each = stepSpecs.iterator();
    final List visitables = _visitables.get("stepSpecs");
    while (each.hasNext()) {
      TaskRunStepSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildStepSpecs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TaskRunStepSpec> getStepSpecs() {
    return stepSpecs != null ? build(stepSpecs) : null;
  }
  public List<TaskRunStepSpec> buildStepSpecs() {
    return stepSpecs != null ? build(stepSpecs) : null;
  }
  public TaskRunStepSpec buildStepSpec(int index) {
    return this.stepSpecs.get(index).build();
  }
  public TaskRunStepSpec buildFirstStepSpec() {
    return this.stepSpecs.get(0).build();
  }
  public TaskRunStepSpec buildLastStepSpec() {
    return this.stepSpecs.get(stepSpecs.size() - 1).build();
  }
  public TaskRunStepSpec buildMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
    for (TaskRunStepSpecBuilder item: stepSpecs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
    for (TaskRunStepSpecBuilder item: stepSpecs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withStepSpecs(List<TaskRunStepSpec> stepSpecs) {
    if (this.stepSpecs != null) { _visitables.get("stepSpecs").clear();}
    if (stepSpecs != null) {this.stepSpecs = new ArrayList(); for (TaskRunStepSpec item : stepSpecs){this.addToStepSpecs(item);}} else { this.stepSpecs = null;} return (A) this;
  }
  public A withStepSpecs(io.fabric8.tekton.pipeline.v1.TaskRunStepSpec... stepSpecs) {
    if (this.stepSpecs != null) {this.stepSpecs.clear(); _visitables.remove("stepSpecs"); }
    if (stepSpecs != null) {for (TaskRunStepSpec item :stepSpecs){ this.addToStepSpecs(item);}} return (A) this;
  }
  public Boolean hasStepSpecs() {
    return stepSpecs != null && !stepSpecs.isEmpty();
  }
  public PipelineTaskRunSpecFluentImpl.StepSpecsNested<A> addNewStepSpec() {
    return new PipelineTaskRunSpecFluentImpl.StepSpecsNestedImpl();
  }
  public PipelineTaskRunSpecFluentImpl.StepSpecsNested<A> addNewStepSpecLike(TaskRunStepSpec item) {
    return new PipelineTaskRunSpecFluentImpl.StepSpecsNestedImpl(-1, item);
  }
  public PipelineTaskRunSpecFluentImpl.StepSpecsNested<A> setNewStepSpecLike(int index,TaskRunStepSpec item) {
    return new PipelineTaskRunSpecFluentImpl.StepSpecsNestedImpl(index, item);
  }
  public PipelineTaskRunSpecFluentImpl.StepSpecsNested<A> editStepSpec(int index) {
    if (stepSpecs.size() <= index) throw new RuntimeException("Can't edit stepSpecs. Index exceeds size.");
    return setNewStepSpecLike(index, buildStepSpec(index));
  }
  public PipelineTaskRunSpecFluentImpl.StepSpecsNested<A> editFirstStepSpec() {
    if (stepSpecs.size() == 0) throw new RuntimeException("Can't edit first stepSpecs. The list is empty.");
    return setNewStepSpecLike(0, buildStepSpec(0));
  }
  public PipelineTaskRunSpecFluentImpl.StepSpecsNested<A> editLastStepSpec() {
    int index = stepSpecs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last stepSpecs. The list is empty.");
    return setNewStepSpecLike(index, buildStepSpec(index));
  }
  public PipelineTaskRunSpecFluentImpl.StepSpecsNested<A> editMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<stepSpecs.size();i++) { 
    if (predicate.test(stepSpecs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching stepSpecs. No match found.");
    return setNewStepSpecLike(index, buildStepSpec(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PipelineTaskRunSpecFluentImpl that = (PipelineTaskRunSpecFluentImpl) o;
    if (!java.util.Objects.equals(computeResources, that.computeResources)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(pipelineTaskName, that.pipelineTaskName)) return false;

    if (!java.util.Objects.equals(podTemplate, that.podTemplate)) return false;

    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;

    if (!java.util.Objects.equals(sidecarSpecs, that.sidecarSpecs)) return false;

    if (!java.util.Objects.equals(stepSpecs, that.stepSpecs)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(computeResources,  metadata,  pipelineTaskName,  podTemplate,  serviceAccountName,  sidecarSpecs,  stepSpecs,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (computeResources != null) { sb.append("computeResources:"); sb.append(computeResources + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (pipelineTaskName != null) { sb.append("pipelineTaskName:"); sb.append(pipelineTaskName + ","); }
    if (podTemplate != null) { sb.append("podTemplate:"); sb.append(podTemplate + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (sidecarSpecs != null) { sb.append("sidecarSpecs:"); sb.append(sidecarSpecs + ","); }
    if (stepSpecs != null) { sb.append("stepSpecs:"); sb.append(stepSpecs); }
    sb.append("}");
    return sb.toString();
  }
  class ComputeResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<PipelineTaskRunSpecFluentImpl.ComputeResourcesNested<N>> implements PipelineTaskRunSpecFluentImpl.ComputeResourcesNested<N>,Nested<N>{
    ComputeResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ComputeResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) PipelineTaskRunSpecFluentImpl.this.withComputeResources(builder.build());
    }
    public N endComputeResources() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends PipelineTaskMetadataFluentImpl<PipelineTaskRunSpecFluentImpl.MetadataNested<N>> implements PipelineTaskRunSpecFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(PipelineTaskMetadata item) {
      this.builder = new PipelineTaskMetadataBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new PipelineTaskMetadataBuilder(this);
    }
    PipelineTaskMetadataBuilder builder;
    public N and() {
      return (N) PipelineTaskRunSpecFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class PodTemplateNestedImpl<N> extends TemplateFluentImpl<PipelineTaskRunSpecFluentImpl.PodTemplateNested<N>> implements PipelineTaskRunSpecFluentImpl.PodTemplateNested<N>,Nested<N>{
    PodTemplateNestedImpl(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    PodTemplateNestedImpl() {
      this.builder = new TemplateBuilder(this);
    }
    TemplateBuilder builder;
    public N and() {
      return (N) PipelineTaskRunSpecFluentImpl.this.withPodTemplate(builder.build());
    }
    public N endPodTemplate() {
      return and();
    }
    
  }
  class SidecarSpecsNestedImpl<N> extends TaskRunSidecarSpecFluentImpl<PipelineTaskRunSpecFluentImpl.SidecarSpecsNested<N>> implements PipelineTaskRunSpecFluentImpl.SidecarSpecsNested<N>,Nested<N>{
    SidecarSpecsNestedImpl(int index,TaskRunSidecarSpec item) {
      this.index = index;
      this.builder = new TaskRunSidecarSpecBuilder(this, item);
    }
    SidecarSpecsNestedImpl() {
      this.index = -1;
      this.builder = new TaskRunSidecarSpecBuilder(this);
    }
    TaskRunSidecarSpecBuilder builder;
    int index;
    public N and() {
      return (N) PipelineTaskRunSpecFluentImpl.this.setToSidecarSpecs(index,builder.build());
    }
    public N endSidecarSpec() {
      return and();
    }
    
  }
  class StepSpecsNestedImpl<N> extends TaskRunStepSpecFluentImpl<PipelineTaskRunSpecFluentImpl.StepSpecsNested<N>> implements PipelineTaskRunSpecFluentImpl.StepSpecsNested<N>,Nested<N>{
    StepSpecsNestedImpl(int index,TaskRunStepSpec item) {
      this.index = index;
      this.builder = new TaskRunStepSpecBuilder(this, item);
    }
    StepSpecsNestedImpl() {
      this.index = -1;
      this.builder = new TaskRunStepSpecBuilder(this);
    }
    TaskRunStepSpecBuilder builder;
    int index;
    public N and() {
      return (N) PipelineTaskRunSpecFluentImpl.this.setToStepSpecs(index,builder.build());
    }
    public N endStepSpec() {
      return and();
    }
    
  }
  
}