package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineTaskRunSpecBuilder extends PipelineTaskRunSpecFluentImpl<PipelineTaskRunSpecBuilder> implements VisitableBuilder<PipelineTaskRunSpec,PipelineTaskRunSpecBuilder>{
  public PipelineTaskRunSpecBuilder() {
    this(false);
  }
  public PipelineTaskRunSpecBuilder(Boolean validationEnabled) {
    this(new PipelineTaskRunSpec(), validationEnabled);
  }
  public PipelineTaskRunSpecBuilder(PipelineTaskRunSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineTaskRunSpecBuilder(PipelineTaskRunSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineTaskRunSpec(), validationEnabled);
  }
  public PipelineTaskRunSpecBuilder(PipelineTaskRunSpecFluent<?> fluent,PipelineTaskRunSpec instance) {
    this(fluent, instance, false);
  }
  public PipelineTaskRunSpecBuilder(PipelineTaskRunSpecFluent<?> fluent,PipelineTaskRunSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withComputeResources(instance.getComputeResources());
      fluent.withMetadata(instance.getMetadata());
      fluent.withPipelineTaskName(instance.getPipelineTaskName());
      fluent.withPodTemplate(instance.getPodTemplate());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withSidecarSpecs(instance.getSidecarSpecs());
      fluent.withStepSpecs(instance.getStepSpecs());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineTaskRunSpecBuilder(PipelineTaskRunSpec instance) {
    this(instance,false);
  }
  public PipelineTaskRunSpecBuilder(PipelineTaskRunSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withComputeResources(instance.getComputeResources());
      this.withMetadata(instance.getMetadata());
      this.withPipelineTaskName(instance.getPipelineTaskName());
      this.withPodTemplate(instance.getPodTemplate());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSidecarSpecs(instance.getSidecarSpecs());
      this.withStepSpecs(instance.getStepSpecs());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineTaskRunSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineTaskRunSpec build() {
    PipelineTaskRunSpec buildable = new PipelineTaskRunSpec(fluent.getComputeResources(),fluent.getMetadata(),fluent.getPipelineTaskName(),fluent.getPodTemplate(),fluent.getServiceAccountName(),fluent.getSidecarSpecs(),fluent.getStepSpecs());
    return buildable;
  }
  
}