package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineTaskMetadataBuilder extends PipelineTaskMetadataFluentImpl<PipelineTaskMetadataBuilder> implements VisitableBuilder<PipelineTaskMetadata,PipelineTaskMetadataBuilder>{
  public PipelineTaskMetadataBuilder() {
    this(false);
  }
  public PipelineTaskMetadataBuilder(Boolean validationEnabled) {
    this(new PipelineTaskMetadata(), validationEnabled);
  }
  public PipelineTaskMetadataBuilder(PipelineTaskMetadataFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineTaskMetadataBuilder(PipelineTaskMetadataFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineTaskMetadata(), validationEnabled);
  }
  public PipelineTaskMetadataBuilder(PipelineTaskMetadataFluent<?> fluent,PipelineTaskMetadata instance) {
    this(fluent, instance, false);
  }
  public PipelineTaskMetadataBuilder(PipelineTaskMetadataFluent<?> fluent,PipelineTaskMetadata instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withLabels(instance.getLabels());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineTaskMetadataBuilder(PipelineTaskMetadata instance) {
    this(instance,false);
  }
  public PipelineTaskMetadataBuilder(PipelineTaskMetadata instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withLabels(instance.getLabels());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineTaskMetadataFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineTaskMetadata build() {
    PipelineTaskMetadata buildable = new PipelineTaskMetadata(fluent.getAnnotations(),fluent.getLabels());
    return buildable;
  }
  
}