package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineTaskBuilder extends PipelineTaskFluentImpl<PipelineTaskBuilder> implements VisitableBuilder<PipelineTask,PipelineTaskBuilder>{
  public PipelineTaskBuilder() {
    this(false);
  }
  public PipelineTaskBuilder(Boolean validationEnabled) {
    this(new PipelineTask(), validationEnabled);
  }
  public PipelineTaskBuilder(PipelineTaskFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineTaskBuilder(PipelineTaskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineTask(), validationEnabled);
  }
  public PipelineTaskBuilder(PipelineTaskFluent<?> fluent,PipelineTask instance) {
    this(fluent, instance, false);
  }
  public PipelineTaskBuilder(PipelineTaskFluent<?> fluent,PipelineTask instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withMatrix(instance.getMatrix());
      fluent.withName(instance.getName());
      fluent.withParams(instance.getParams());
      fluent.withRetries(instance.getRetries());
      fluent.withRunAfter(instance.getRunAfter());
      fluent.withTaskRef(instance.getTaskRef());
      fluent.withTaskSpec(instance.getTaskSpec());
      fluent.withTimeout(instance.getTimeout());
      fluent.withWhen(instance.getWhen());
      fluent.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineTaskBuilder(PipelineTask instance) {
    this(instance,false);
  }
  public PipelineTaskBuilder(PipelineTask instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withMatrix(instance.getMatrix());
      this.withName(instance.getName());
      this.withParams(instance.getParams());
      this.withRetries(instance.getRetries());
      this.withRunAfter(instance.getRunAfter());
      this.withTaskRef(instance.getTaskRef());
      this.withTaskSpec(instance.getTaskSpec());
      this.withTimeout(instance.getTimeout());
      this.withWhen(instance.getWhen());
      this.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineTaskFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineTask build() {
    PipelineTask buildable = new PipelineTask(fluent.getDescription(),fluent.getDisplayName(),fluent.getMatrix(),fluent.getName(),fluent.getParams(),fluent.getRetries(),fluent.getRunAfter(),fluent.getTaskRef(),fluent.getTaskSpec(),fluent.getTimeout(),fluent.getWhen(),fluent.getWorkspaces());
    return buildable;
  }
  
}