package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineSpecBuilder extends PipelineSpecFluentImpl<PipelineSpecBuilder> implements VisitableBuilder<PipelineSpec,PipelineSpecBuilder>{
  public PipelineSpecBuilder() {
    this(false);
  }
  public PipelineSpecBuilder(Boolean validationEnabled) {
    this(new PipelineSpec(), validationEnabled);
  }
  public PipelineSpecBuilder(PipelineSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineSpecBuilder(PipelineSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineSpec(), validationEnabled);
  }
  public PipelineSpecBuilder(PipelineSpecFluent<?> fluent,PipelineSpec instance) {
    this(fluent, instance, false);
  }
  public PipelineSpecBuilder(PipelineSpecFluent<?> fluent,PipelineSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withFinally(instance.getFinally());
      fluent.withParams(instance.getParams());
      fluent.withResults(instance.getResults());
      fluent.withTasks(instance.getTasks());
      fluent.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineSpecBuilder(PipelineSpec instance) {
    this(instance,false);
  }
  public PipelineSpecBuilder(PipelineSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withFinally(instance.getFinally());
      this.withParams(instance.getParams());
      this.withResults(instance.getResults());
      this.withTasks(instance.getTasks());
      this.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineSpec build() {
    PipelineSpec buildable = new PipelineSpec(fluent.getDescription(),fluent.getDisplayName(),fluent.getFinally(),fluent.getParams(),fluent.getResults(),fluent.getTasks(),fluent.getWorkspaces());
    return buildable;
  }
  
}