package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineRunSpecBuilder extends PipelineRunSpecFluentImpl<PipelineRunSpecBuilder> implements VisitableBuilder<PipelineRunSpec,PipelineRunSpecBuilder>{
  public PipelineRunSpecBuilder() {
    this(false);
  }
  public PipelineRunSpecBuilder(Boolean validationEnabled) {
    this(new PipelineRunSpec(), validationEnabled);
  }
  public PipelineRunSpecBuilder(PipelineRunSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineRunSpecBuilder(PipelineRunSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineRunSpec(), validationEnabled);
  }
  public PipelineRunSpecBuilder(PipelineRunSpecFluent<?> fluent,PipelineRunSpec instance) {
    this(fluent, instance, false);
  }
  public PipelineRunSpecBuilder(PipelineRunSpecFluent<?> fluent,PipelineRunSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withParams(instance.getParams());
      fluent.withPipelineRef(instance.getPipelineRef());
      fluent.withPipelineSpec(instance.getPipelineSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withTaskRunSpecs(instance.getTaskRunSpecs());
      fluent.withTaskRunTemplate(instance.getTaskRunTemplate());
      fluent.withTimeouts(instance.getTimeouts());
      fluent.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineRunSpecBuilder(PipelineRunSpec instance) {
    this(instance,false);
  }
  public PipelineRunSpecBuilder(PipelineRunSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withParams(instance.getParams());
      this.withPipelineRef(instance.getPipelineRef());
      this.withPipelineSpec(instance.getPipelineSpec());
      this.withStatus(instance.getStatus());
      this.withTaskRunSpecs(instance.getTaskRunSpecs());
      this.withTaskRunTemplate(instance.getTaskRunTemplate());
      this.withTimeouts(instance.getTimeouts());
      this.withWorkspaces(instance.getWorkspaces());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineRunSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineRunSpec build() {
    PipelineRunSpec buildable = new PipelineRunSpec(fluent.getParams(),fluent.getPipelineRef(),fluent.getPipelineSpec(),fluent.getStatus(),fluent.getTaskRunSpecs(),fluent.getTaskRunTemplate(),fluent.getTimeouts(),fluent.getWorkspaces());
    return buildable;
  }
  
}