package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineRunResultBuilder extends PipelineRunResultFluentImpl<PipelineRunResultBuilder> implements VisitableBuilder<PipelineRunResult,PipelineRunResultBuilder>{
  public PipelineRunResultBuilder() {
    this(false);
  }
  public PipelineRunResultBuilder(Boolean validationEnabled) {
    this(new PipelineRunResult(), validationEnabled);
  }
  public PipelineRunResultBuilder(PipelineRunResultFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineRunResultBuilder(PipelineRunResultFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineRunResult(), validationEnabled);
  }
  public PipelineRunResultBuilder(PipelineRunResultFluent<?> fluent,PipelineRunResult instance) {
    this(fluent, instance, false);
  }
  public PipelineRunResultBuilder(PipelineRunResultFluent<?> fluent,PipelineRunResult instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineRunResultBuilder(PipelineRunResult instance) {
    this(instance,false);
  }
  public PipelineRunResultBuilder(PipelineRunResult instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineRunResultFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineRunResult build() {
    PipelineRunResult buildable = new PipelineRunResult(fluent.getName(),fluent.getValue());
    return buildable;
  }
  
}