package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineRunListBuilder extends PipelineRunListFluentImpl<PipelineRunListBuilder> implements VisitableBuilder<PipelineRunList,PipelineRunListBuilder>{
  public PipelineRunListBuilder() {
    this(false);
  }
  public PipelineRunListBuilder(Boolean validationEnabled) {
    this(new PipelineRunList(), validationEnabled);
  }
  public PipelineRunListBuilder(PipelineRunListFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineRunListBuilder(PipelineRunListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineRunList(), validationEnabled);
  }
  public PipelineRunListBuilder(PipelineRunListFluent<?> fluent,PipelineRunList instance) {
    this(fluent, instance, false);
  }
  public PipelineRunListBuilder(PipelineRunListFluent<?> fluent,PipelineRunList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineRunListBuilder(PipelineRunList instance) {
    this(instance,false);
  }
  public PipelineRunListBuilder(PipelineRunList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineRunListFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineRunList build() {
    PipelineRunList buildable = new PipelineRunList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}