package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PipelineListBuilder extends PipelineListFluentImpl<PipelineListBuilder> implements VisitableBuilder<PipelineList,PipelineListBuilder>{
  public PipelineListBuilder() {
    this(false);
  }
  public PipelineListBuilder(Boolean validationEnabled) {
    this(new PipelineList(), validationEnabled);
  }
  public PipelineListBuilder(PipelineListFluent<?> fluent) {
    this(fluent, false);
  }
  public PipelineListBuilder(PipelineListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PipelineList(), validationEnabled);
  }
  public PipelineListBuilder(PipelineListFluent<?> fluent,PipelineList instance) {
    this(fluent, instance, false);
  }
  public PipelineListBuilder(PipelineListFluent<?> fluent,PipelineList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PipelineListBuilder(PipelineList instance) {
    this(instance,false);
  }
  public PipelineListBuilder(PipelineList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  PipelineListFluent<?> fluent;
  Boolean validationEnabled;
  public PipelineList build() {
    PipelineList buildable = new PipelineList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}