package io.fabric8.tekton.pipeline.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PipelineFluentImpl<A extends PipelineFluent<A>> extends BaseFluent<A> implements PipelineFluent<A>{
  public PipelineFluentImpl() {
  }
  public PipelineFluentImpl(Pipeline instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private PipelineSpecBuilder spec;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public PipelineFluentImpl.MetadataNested<A> withNewMetadata() {
    return new PipelineFluentImpl.MetadataNestedImpl();
  }
  public PipelineFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new PipelineFluentImpl.MetadataNestedImpl(item);
  }
  public PipelineFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public PipelineFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public PipelineFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public PipelineSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public PipelineSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(PipelineSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new PipelineSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public PipelineFluentImpl.SpecNested<A> withNewSpec() {
    return new PipelineFluentImpl.SpecNestedImpl();
  }
  public PipelineFluentImpl.SpecNested<A> withNewSpecLike(PipelineSpec item) {
    return new PipelineFluentImpl.SpecNestedImpl(item);
  }
  public PipelineFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public PipelineFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new PipelineSpecBuilder().build());
  }
  public PipelineFluentImpl.SpecNested<A> editOrNewSpecLike(PipelineSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PipelineFluentImpl that = (PipelineFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PipelineFluentImpl.MetadataNested<N>> implements PipelineFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) PipelineFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends PipelineSpecFluentImpl<PipelineFluentImpl.SpecNested<N>> implements PipelineFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(PipelineSpec item) {
      this.builder = new PipelineSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new PipelineSpecBuilder(this);
    }
    PipelineSpecBuilder builder;
    public N and() {
      return (N) PipelineFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  
}